<?php
/**
	Penguin Framework

	Copyright (c) 2009-2015 ThemeFocus

	@url http://penguin.themefocus.co
	@package Penguin
	@version 6.0
**/

global $google_fonts;
/**
 * Google Web Font now 696
 * http://www.google.com/webfonts
 * <link href='http://fonts.googleapis.com/css?family=...'rel='stylesheet' type='text/css'>
 */
$google_fonts = 'ABeeZee|Abel|Abril+Fatface|Aclonica|Acme|Actor|Adamina|Advent+Pro|Aguafina+Script|Akronim|Aladin|Aldrich|Alef|Alegreya|Alegreya+SC|Alegreya+Sans|Alegreya+Sans+SC|Alex+Brush|Alfa+Slab+One|Alice|Alike|Alike+Angular|Allan|Allerta|Allerta+Stencil|Allura|Almendra|Almendra+Display|Almendra+SC|Amarante|Amaranth|Amatic+SC|Amethysta|Amiri|Amita|Anaheim|Andada|Andika|Angkor|Annie+Use+Your+Telescope|Anonymous+Pro|Antic|Antic+Didone|Antic+Slab|Anton|Arapey|Arbutus|Arbutus+Slab|Architects+Daughter|Archivo+Black|Archivo+Narrow|Arimo|Arizonia|Armata|Artifika|Arvo|Arya|Asap|Asar|Asset|Astloch|Asul|Atomic+Age|Aubrey|Audiowide|Autour+One|Average|Average+Sans|Averia+Gruesa+Libre|Averia+Libre|Averia+Sans+Libre|Averia+Serif+Libre|Bad+Script|Balthazar|Bangers|Basic|Battambang|Baumans|Bayon|Belgrano|Belleza|BenchNine|Bentham|Berkshire+Swash|Bevan|Bigelow+Rules|Bigshot+One|Bilbo|Bilbo+Swash+Caps|Biryani|Bitter|Black+Ops+One|Bokor|Bonbon|Boogaloo|Bowlby+One|Bowlby+One+SC|Brawler|Bree+Serif|Bubblegum+Sans|Bubbler+One|Buda|Buenard|Butcherman|Butterfly+Kids|Cabin|Cabin+Condensed|Cabin+Sketch|Caesar+Dressing|Cagliostro|Calligraffitti|Cambay|Cambo|Candal|Cantarell|Cantata+One|Cantora+One|Capriola|Cardo|Carme|Carrois+Gothic|Carrois+Gothic+SC|Carter+One|Caudex|Cedarville+Cursive|Ceviche+One|Changa+One|Chango|Chau+Philomene+One|Chela+One|Chelsea+Market|Chenla|Cherry+Cream+Soda|Cherry+Swash|Chewy|Chicle|Chivo|Cinzel|Cinzel+Decorative|Clicker+Script|Coda|Coda+Caption|Codystar|Combo|Comfortaa|Coming+Soon|Concert+One|Condiment|Content|Contrail+One|Convergence|Cookie|Copse|Corben|Courgette|Cousine|Coustard|Covered+By+Your+Grace|Crafty+Girls|Creepster|Crete+Round|Crimson+Text|Croissant+One|Crushed|Cuprum|Cutive|Cutive+Mono|Damion|Dancing+Script|Dangrek|Dawning+of+a+New+Day|Days+One|Dekko|Delius|Delius+Swash+Caps|Delius+Unicase|Della+Respira|Denk+One|Devonshire|Dhurjati|Didact+Gothic|Diplomata|Diplomata+SC|Domine|Donegal+One|Doppio+One|Dorsa|Dosis|Dr+Sugiyama|Droid+Sans|Droid+Sans+Mono|Droid+Serif|Duru+Sans|Dynalight|EB+Garamond|Eagle+Lake|Eater|Economica|Eczar|Ek+Mukta|Electrolize|Elsie|Elsie+Swash+Caps|Emblema+One|Emilys+Candy|Engagement|Englebert|Enriqueta|Erica+One|Esteban|Euphoria+Script|Ewert|Exo|Exo+2|Expletus+Sans|Fanwood+Text|Fascinate|Fascinate+Inline|Faster+One|Fasthand|Fauna+One|Federant|Federo|Felipa|Fenix|Finger+Paint|Fira+Mono|Fira+Sans|Fjalla+One|Fjord+One|Flamenco|Flavors|Fondamento|Fontdiner+Swanky|Forum|Francois+One|Freckle+Face|Fredericka+the+Great|Fredoka+One|Freehand|Fresca|Frijole|Fruktur|Fugaz+One|GFS+Didot|GFS+Neohellenic|Gabriela|Gafata|Galdeano|Galindo|Gentium+Basic|Gentium+Book+Basic|Geo|Geostar|Geostar+Fill|Germania+One|Gidugu|Gilda+Display|Give+You+Glory|Glass+Antiqua|Glegoo|Gloria+Hallelujah|Goblin+One|Gochi+Hand|Gorditas|Goudy+Bookletter+1911|Graduate|Grand+Hotel|Gravitas+One|Great+Vibes|Griffy|Gruppo|Gudea|Gurajada|Habibi|Halant|Hammersmith+One|Hanalei|Hanalei+Fill|Handlee|Hanuman|Happy+Monkey|Headland+One|Henny+Penny|Herr+Von+Muellerhoff|Hind|Holtwood+One+SC|Homemade+Apple|Homenaje|IM+Fell+DW+Pica|IM+Fell+DW+Pica+SC|IM+Fell+Double+Pica|IM+Fell+Double+Pica+SC|IM+Fell+English|IM+Fell+English+SC|IM+Fell+French+Canon|IM+Fell+French+Canon+SC|IM+Fell+Great+Primer|IM+Fell+Great+Primer+SC|Iceberg|Iceland|Imprima|Inconsolata|Inder|Indie+Flower|Inika|Inknut+Antiqua|Irish+Grover|Istok+Web|Italiana|Italianno|Jacques+Francois|Jacques+Francois+Shadow|Jaldi|Jim+Nightshade|Jockey+One|Jolly+Lodger|Josefin+Sans|Josefin+Slab|Joti+One|Judson|Julee|Julius+Sans+One|Junge|Jura|Just+Another+Hand|Just+Me+Again+Down+Here|Kadwa|Kalam|Kameron|Kantumruy|Karla|Karma|Kaushan+Script|Kavoon|Kdam+Thmor|Keania+One|Kelly+Slab|Kenia|Khand|Khmer|Khula|Kite+One|Knewave|Kotta+One|Koulen|Kranky|Kreon|Kristi|Krona+One|Kurale|La+Belle+Aurore|Laila|Lakki+Reddy|Lancelot|Lateef|Lato|League+Script|Leckerli+One|Ledger|Lekton|Lemon|Libre+Baskerville|Life+Savers|Lilita+One|Lily+Script+One|Limelight|Linden+Hill|Lobster|Lobster+Two|Londrina+Outline|Londrina+Shadow|Londrina+Sketch|Londrina+Solid|Lora|Love+Ya+Like+A+Sister|Loved+by+the+King|Lovers+Quarrel|Luckiest+Guy|Lusitana|Lustria|Macondo|Macondo+Swash+Caps|Magra|Maiden+Orange|Mako|Mallanna|Mandali|Marcellus|Marcellus+SC|Marck+Script|Margarine|Marko+One|Marmelad|Martel|Martel+Sans|Marvel|Mate|Mate+SC|Maven+Pro|McLaren|Meddon|MedievalSharp|Medula+One|Megrim|Meie+Script|Merienda|Merienda+One|Merriweather|Merriweather+Sans|Metal|Metal+Mania|Metamorphous|Metrophobic|Michroma|Milonga|Miltonian|Miltonian+Tattoo|Miniver|Miss+Fajardose|Modak|Modern+Antiqua|Molengo|Molle|Monda|Monofett|Monoton|Monsieur+La+Doulaise|Montaga|Montez|Montserrat|Montserrat+Alternates|Montserrat+Subrayada|Moul|Moulpali|Mountains+of+Christmas|Mouse+Memoirs|Mr+Bedfort|Mr+Dafoe|Mr+De+Haviland|Mrs+Saint+Delafield|Mrs+Sheppards|Muli|Mystery+Quest|NTR|Neucha|Neuton|New+Rocker|News+Cycle|Niconne|Nixie+One|Nobile|Nokora|Norican|Nosifer|Nothing+You+Could+Do|Noticia+Text|Noto+Sans|Noto+Serif|Nova+Cut|Nova+Flat|Nova+Mono|Nova+Oval|Nova+Round|Nova+Script|Nova+Slim|Nova+Square|Numans|Nunito|Odor+Mean+Chey|Offside|Old+Standard+TT|Oldenburg|Oleo+Script|Oleo+Script+Swash+Caps|Open+Sans|Open+Sans+Condensed|Oranienbaum|Orbitron|Oregano|Orienta|Original+Surfer|Oswald|Over+the+Rainbow|Overlock|Overlock+SC|Ovo|Oxygen|Oxygen+Mono|PT+Mono|PT+Sans|PT+Sans+Caption|PT+Sans+Narrow|PT+Serif|PT+Serif+Caption|Pacifico|Palanquin|Palanquin+Dark|Paprika|Parisienne|Passero+One|Passion+One|Pathway+Gothic+One|Patrick+Hand|Patrick+Hand+SC|Patua+One|Paytone+One|Peddana|Peralta|Permanent+Marker|Petit+Formal+Script|Petrona|Philosopher|Piedra|Pinyon+Script|Pirata+One|Plaster|Play|Playball|Playfair+Display|Playfair+Display+SC|Podkova|Poiret+One|Poller+One|Poly|Pompiere|Pontano+Sans|Poppins|Port+Lligat+Sans|Port+Lligat+Slab|Pragati+Narrow|Prata|Preahvihear|Press+Start+2P|Princess+Sofia|Prociono|Prosto+One|Puritan|Purple+Purse|Quando|Quantico|Quattrocento|Quattrocento+Sans|Questrial|Quicksand|Quintessential|Qwigley|Racing+Sans+One|Radley|Rajdhani|Raleway|Raleway+Dots|Ramabhadra|Ramaraja|Rambla|Rammetto+One|Ranchers|Rancho|Ranga|Rationale|Ravi+Prakash|Redressed|Reenie+Beanie|Revalia|Rhodium+Libre|Ribeye|Ribeye+Marrow|Righteous|Risque|Roboto|Roboto+Condensed|Roboto+Mono|Roboto+Slab|Rochester|Rock+Salt|Rokkitt|Romanesco|Ropa+Sans|Rosario|Rosarivo|Rouge+Script|Rozha+One|Rubik+Mono+One|Rubik+One|Ruda|Rufina|Ruge+Boogie|Ruluko|Rum+Raisin|Ruslan+Display|Russo+One|Ruthie|Rye|Sacramento|Sahitya|Sail|Salsa|Sanchez|Sancreek|Sansita+One|Sarala|Sarina|Sarpanch|Satisfy|Scada|Scheherazade|Schoolbell|Seaweed+Script|Sevillana|Seymour+One|Shadows+Into+Light|Shadows+Into+Light+Two|Shanti|Share|Share+Tech|Share+Tech+Mono|Shojumaru|Short+Stack|Siemreap|Sigmar+One|Signika|Signika+Negative|Simonetta|Sintony|Sirin+Stencil|Six+Caps|Skranji|Slabo+13px|Slabo+27px|Slackey|Smokum|Smythe|Sniglet|Snippet|Snowburst+One|Sofadi+One|Sofia|Sonsie+One|Sorts+Mill+Goudy|Source+Code+Pro|Source+Sans+Pro|Source+Serif+Pro|Special+Elite|Spicy+Rice|Spinnaker|Spirax|Squada+One|Sree+Krushnadevaraya|Stalemate|Stalinist+One|Stardos+Stencil|Stint+Ultra+Condensed|Stint+Ultra+Expanded|Stoke|Strait|Sue+Ellen+Francisco|Sumana|Sunshiney|Supermercado+One|Sura|Suranna|Suravaram|Suwannaphum|Swanky+and+Moo+Moo|Syncopate|Tangerine|Taprom|Tauri|Teko|Telex|Tenali+Ramakrishna|Tenor+Sans|Text+Me+One|The+Girl+Next+Door|Tienne|Tillana|Timmana|Tinos|Titan+One|Titillium+Web|Trade+Winds|Trocchi|Trochut|Trykker|Tulpen+One|Ubuntu|Ubuntu+Condensed|Ubuntu+Mono|Ultra|Uncial+Antiqua|Underdog|Unica+One|UnifrakturCook|UnifrakturMaguntia|Unkempt|Unlock|Unna|VT323|Vampiro+One|Varela|Varela+Round|Vast+Shadow|Vesper+Libre|Vibur|Vidaloka|Viga|Voces|Volkhov|Vollkorn|Voltaire|Waiting+for+the+Sunrise|Wallpoet|Walter+Turncoat|Warnes|Wellfleet|Wendy+One|Wire+One|Yanone+Kaffeesatz|Yantramanav|Yellowtail|Yeseva+One|Yesteryear|Zeyada';

//========================================================
//  	COMMON FUNCTION METHODS
//========================================================

if ( ! function_exists( 'penguin_get_options_key' ) ) :
/**
 * Get custom option key value
 * !IMPORTANT HERE NEED SETTING DEFAULT THEME OPTIONS
 * HERE USED alterna OPTIONS
 * @since penguin 6.0
 */
function penguin_get_options_key($key, $options = '', $rebool = false, $default = '', $is_meta = false){
	if($options == ''){
		global $alterna_options;
		$options = $alterna_options;	
	}
	
	if(isset($options[$key])){
		if($rebool){return true;}
		if($is_meta && is_array($options[$key]) && isset($options[$key][0])){
			return $options[$key][0];
		}
		return $options[$key];
	}else{
		if($rebool){return false;}
	}
	return $default;
}
endif;

if ( ! function_exists( 'penguin_get_post_meta_key' ) ) :
/**
 * Get post meta key value
 *
 * @since penguin 6.0
 */
function penguin_get_post_meta_key($key, $ID = 0, $default = ''){
	if($ID == 0){ $ID = get_the_ID(); }
	if($ID <= 0){ return $default;}
	$result = get_post_meta($ID , $key , true);
	if($result){ return $result; }
	return $default;
}
endif;

if ( ! function_exists( 'penguin_get_current_font_name' ) ) :
/**
 * Get current font name
 *
 * @since penguin 6.0
 */
function penguin_get_current_font_name($font_name){
	$arr = explode(":", str_replace("+"," ",$font_name) );
	return $arr[0];
}
endif;

if ( ! function_exists( 'penguin_get_current_bool_value' ) ) :
/**
 * Get current bool value
 *
 * @since penguin 6.0
 */
function penguin_get_current_bool_value($value){
	if($value == "on" || ($value != "off" && intval($value) == 0)){
		return true;
	}
	return false;
}
endif;

if ( ! function_exists( 'penguin_get_custom_field' ) ) :
/**
 * Get custom field
 *
 * @since penguin 6.0
 */
function penguin_get_custom_field($options, $key){
	$field_arr = array();
	if($options && isset($options[$key]) && $options[$key] != ''){
		$field_value = $options[$key];
		$lines = explode("\n", $field_value);
		if(count($lines) > 0){
			foreach($lines as $line){
				$fields = explode(":", $line);
				if(count($fields) >= 3){
					$new_field = array('name' => $fields[0], 'field' => array() );
					$count = 0;
					foreach($fields as $field){
						if($count != 0){
							$new_field['field'][] = $field;
						}
						$count++;
					}
					$field_arr[] = $new_field;
				}
			}
		}
	}
	return $field_arr;
}
endif;

if ( ! function_exists( 'penguin_generate_options_css' ) ) :
/**
 * Generate Options CSS
 *
 * @since penguin 6.0
 */
function penguin_generate_options_css() {
	$options_update_name = Penguin::$THEME_NAME.'_options_update';
	//get theme update history
	$options_update = get_option($options_update_name);
	
	//get theme version
	$theme_old_version = get_option($options_update_name.'-ver');
	$theme_data = wp_get_theme();
	if($theme_data->Template != ''){
		$theme_data = wp_get_theme($theme_data->Template);
	}
	if(!$theme_old_version){
		$theme_old_version = $theme_data['Version'];
		update_option($options_update_name.'-ver', $theme_data['Version']);
	}
	
	/** Define some vars **/
	$uploads = wp_upload_dir();
	
	/** Save on different directory if on multisite **/
	if(is_multisite()) {
		$uploads_dir = $uploads['basedir'].'/'.Penguin::$THEME_NAME.'/';
	} else {
		$uploads_dir = $uploads['basedir'].'/'.Penguin::$THEME_NAME.'/';
	}
	
	if(!is_writable($uploads['basedir'])) {
		echo 'Your upload can\'t write theme style files.';
		return;
	}
	// Create necessary folders under /uploads
	if(!file_exists($uploads_dir)) { mkdir($uploads_dir, 0755); }
	
	if(isset($options_update['update'])){
		if($options_update['update'] == 'yes'){
			if(version_compare($theme_data['Version'], $theme_old_version, '>')){
				update_option($options_update_name.'-ver', $theme_data['Version']);
			}else{
				if (file_exists($uploads_dir . Penguin::$THEME_NAME.'-styles.css')) {
					if (class_exists( 'woocommerce' ) && file_exists($uploads_dir . Penguin::$THEME_NAME.'-woocommerce.css')) { 
						return;
					}else{
						return;
					}
				}
			}
		}
		$update_data = array('update'=>'yes','version'=> (intval($options_update['version']) + 1) );
	}else{
		$update_data = array('update'=>'yes','version'=> 0 );
	}
	/** Capture CSS output **/

	require_once('tools/less.php/Less.php');

	global $theme_customize_list, $woocommerce_customize_list;
	
	$theme_customize_list = array();
	$woocommerce_customize_list = array();
	
	require( get_template_directory() . '/customize/customize.php');
	
	//theme
	$parser = new Less_Parser();
	$parser->parseFile( get_template_directory(). '/css/less/'.Penguin::$THEME_NAME.'.less', get_template_directory(). '/css/');
	$parser->ModifyVars($theme_customize_list);
	$css = $parser->getCss();
	
	// background custom
	ob_start();
	require( get_template_directory() . '/customize/customize-bg.php');
	$css .= ob_get_clean();
	
	/** Write to file **/
	WP_Filesystem();
	global $wp_filesystem;
	if ( ! $wp_filesystem->put_contents( $uploads_dir .  Penguin::$THEME_NAME.'-styles.css', $css, 0644) ) {
		echo 'Write theme css error.';
		return;
	}
	
	if (class_exists( 'woocommerce' )) { 
		//woocommerce
		$parser = new Less_Parser();
		$parser->parseFile( get_template_directory(). '/woocommerce/assets/css/woocommerce.less', get_template_directory(). '/woocommerce/assets/css/');
		$parser->ModifyVars($woocommerce_customize_list);
		$css = $parser->getCss();
		
		/** Write to file **/
		if ( ! $wp_filesystem->put_contents( $uploads_dir .  Penguin::$THEME_NAME.'-woocommerce.css', $css, 0644) ) {
			echo 'Write woocommerce css error.';
			return;
		}
	}
	
	update_option($options_update_name ,$update_data);
}
endif;

if ( ! function_exists( 'penguin_add_image_size' ) ) :
/**
 * Add custom image size for feature image crop
 *
 * @since penguin 6.0
 */
function penguin_add_image_size($name,$w,$h,$crop = true){
	add_image_size( $name, $w, $h, $crop );
	update_option($name.'_size_w', $w);
	update_option($name.'_size_h', $h);
	update_option($name.'_crop', $crop ? 1 : 0);
}
endif;

if ( ! function_exists( 'penguin_string_limit_words' ) ) :
/**
 * Get limit words
 *
 * @since penguin 6.0
 */
function penguin_string_limit_words($str, $limit = 18 , $need_end = false) {
	$words = explode(' ', $str, ($limit + 1));
	if(count($words) > $limit) {
		array_pop($words);
		array_push($words,'...');
	}
	return implode(' ', $words);
}
endif;

if ( ! function_exists( 'penguin_hex2RGB' ) ) :
/**
 * Get common hex to rgb
 *
 * @since penguin 6.0
 */
function penguin_hex2RGB($color) {
	if ($color[0] == '#'){
        $color = substr($color, 1);
	}

    if (strlen($color) == 6){
        list($r, $g, $b) = array($color[0].$color[1],$color[2].$color[3],$color[4].$color[5]);
	}
    elseif (strlen($color) == 3){
        list($r, $g, $b) = array($color[0].$color[0], $color[1].$color[1], $color[2].$color[2]);
	}else{
        return false;
	}

    $r = hexdec($r); $g = hexdec($g); $b = hexdec($b);

    return array('r' => $r, 'g' => $g, 'b' => $b);
}
endif;


if ( ! function_exists( 'penguin_add_or_update_url_param' ) ) :
/**
 * add or update url param
 *
 * @since penguin 6.0
 */
function penguin_add_or_update_url_param($key, $value, $url) {
    $info = parse_url( $url );
	if(!isset($info['query'])){
		return $url . '?' . $key . '=' . $value;
	}
	parse_str( $info['query'], $query );
	if(!isset($info['path'])){
		$info['path'] = '';
	}
    return $info['scheme'] . '://' . $info['host'] . $info['path'] . '?' . http_build_query( $query ? array_merge( $query, array($key => $value ) ) : array( $key => $value ) );
}
endif;

if ( ! function_exists( 'penguin_add_param_for_link' ) ) :
/**
 * get custom param link
 */
function penguin_add_param_for_link($link,$param){
	if(!strpos($link,'?')){
		return $link.'?'.$param;
	}
	return $link.'&amp;'.$param;
}
endif;

//========================================================
//  	POSTS FUNCTION METHODS
//========================================================

if ( ! function_exists( 'penguin_get_custom_post_taxonomy' ) ) :
/**
 * Get Custom Taxonomy List
 *
 * @since penguin 6.0
 */
function penguin_get_custom_post_taxonomy($taxonomy, $show_count = false) {
	$categories = get_terms( $taxonomy );
	$output = '<ul>';
	if(count($categories) > 0){
		foreach($categories as $category){
			$output .= '<li><a href="'.get_term_link($category -> slug, $taxonomy).'">'.$category -> name.'';
			if($show_count){
				$output .= '<span class="count"> ('.$category -> count.') </span>';
			}
			$output .= '</a></li>';
		}
	}
	$output .= '</ul>';
	return $output;
}
endif;

if ( ! function_exists( 'penguin_get_all_template_type_pages' ) ) :
/**
 * Get All Template Type Pages
 *
 * @since penguin 6.0
 */
function penguin_get_all_template_type_pages($template = array(), $re_id = false) {
	$template_pages = array();
	$p_types = $template;
	if(count($p_types) > 0){
		foreach($p_types as $p_type){
			$args = array(
				'meta_key' => '_wp_page_template',
				'meta_value' => $p_type,
				'post_type' => 'page',
				'post_status' => 'publish',
				'sort_column' => 'ID',
				'sort_order' => 'asc'
			); 
			$pages = get_pages($args); 
			if(!empty($pages)) {
				foreach($pages as $page){
					if($re_id){
						$template_pages[] = $page->ID;
					}else {
						$template_pages[$page->ID] = $page->post_title;
					}
				}
			}
		}
		if($re_id){
			sort($template_pages, SORT_NUMERIC);
		}else{
			ksort($template_pages, SORT_NUMERIC);
		}
	}
	return $template_pages;
}
endif;

if ( ! function_exists( 'penguin_get_custom_post_categories' ) ) :
/**
 * Get current post categories
 * @bool = true return "," string name
 *
 * @since penguin 6.0
 */
function penguin_get_custom_post_categories($id, $taxonomies, $bool = false, $sep=' , ' , $type = 'name' , $exter = ''){
	$categories = get_the_terms($id,$taxonomies);
	$output = "";
	if($bool && !empty($categories)){
		$first = true;
		foreach($categories as $category){
			if(!$first){
				$output .=$sep;
			}else{
				$first = false;
			}
			$output .= $exter.$category->$type;
		}
	} else {
		return $categories;
	}
	return $output;
}
endif;

if ( ! function_exists( 'penguin_get_custom_blog_posts' ) ) :		
/**
 * Get custom blog posts
 *
 * @since penguin 6.0
 */
function penguin_get_custom_blog_posts($type = "", $per_page = "", $orderby = "", $cat_in = "", $tag_in = "", $post__in = "", $post__not_in = "") {
	
	if($per_page == ""){
		$per_page = 4;
	}
	
	$args = array('post_type' => 'post', 'post_status' => 'publish' , 'posts_per_page' => $per_page);
	
	if($orderby != ""){
		$args['orderby']  = $orderby;
	}
	
	switch($type){
		case 'featured':
				$post_ids = explode("," , $post__in);
				if(count($post_ids) == 0){
					return "";
				}
				$args['post__in']= $post_ids;
				$args['posts_per_page']= count($post_ids);
				break;
		case 'popular':
				$args['orderby']= 'comment_count';
				break;
		case 'related':
				if($cat_in != ""){
					$args['category_name'] = $cat_in;
				}
				if($tag_in != ""){
					$args['tag'] = $tag_in;
				}
				break;
	}
	if($post__not_in != ""){
		$post__not_in = explode("," , $post__not_in);
		$args['post__not_in'] = $post__not_in;
	}

	$blog_posts = new WP_Query($args);
	
	return $blog_posts;
}
endif;

if ( ! function_exists( 'penguin_get_custom_post_posts' ) ) :		
/**
 * Get custom post type posts
 *
 * @since penguin 6.0
 */
function penguin_get_custom_post_posts($type = "", $per_page = "", $orderby = "", $cat_in = "", $tag_in = "", $post__in = "", $post__not_in = "", $post_type = 'portfolio') {
	if($per_page == ""){
		$per_page = 4;
	}
	
	$args=array( 'post_type' => $post_type, 'post_status' => 'publish', 'posts_per_page' => $per_page );
	
	if($orderby != ""){
		$args['orderby']  = $orderby;
	}
			 
	switch($type){
		case 'featured':
				$post_ids = explode("," , $post__in);
				if(count($post_ids) == 0){
					return "";
				}
				$args['post__in']= $post_ids;
				$args['posts_per_page']= count($post_ids);
			break;
		case 'related':
				$cat_slugs = explode("," , $cat_in);
				$tag_slugs = explode("," , $tag_in);
				if(count($cat_slugs) == 0 && count($tag_slugs) == 0){
					return "";
				}
				
				$args['tax_query'] = array();
				if(count($cat_slugs) > 0 && $cat_slugs[0] != ""){
					$args['tax_query'][] = array('taxonomy' => $post_type.'-cats', 'field' => 'slug', 'terms' => $cat_slugs);
				}
				
				if(count($tag_slugs) > 0  && $tag_slugs[0] != ""){
					$args['tax_query'][] = array('taxonomy' => $post_type.'-tags', 'field' => 'slug', 'terms' => $tag_slugs);
				}
			break;
	}
	
	if($post__not_in != ""){
		$post__not_in = explode("," , $post__not_in);
		$args['post__not_in'] = $post__not_in;
	}

	$posts = new WP_Query($args);
	
	return $posts;
}
endif;

//========================================================
//  	PLUGIN FUNCTION METHODS
//========================================================

if ( ! function_exists( 'penguin_get_layerslider' ) ) :
/**
 * Get option for layerslider
 *
 * @since penguin 6.0
 */
function penguin_get_layerslider(){
	$layerslider_slides = array();
	$layerslider_slides[0] = __('Select a slider',Penguin::$THEME_NAME);
	
	 // Get WPDB Object
    global $wpdb;
 
    // Table name
    $table_name = $wpdb->prefix . "layerslider";

	$sql = "show tables like '$table_name'";
	
	$table = $wpdb->get_var($sql);

	// have no rev slider 
	if($table != $table_name) return $layerslider_slides;
 
    // Get sliders
    $sliders = $wpdb->get_results( "SELECT * FROM $table_name
                                        WHERE flag_hidden = '0' AND flag_deleted = '0'
                                        ORDER BY date_c ASC LIMIT 100" );
 
    // Iterate over the sliders
    foreach($sliders as $key => $item) {
 		$layerslider_slides[$item->id] = '#'.$item->id . ' - ' .$item->name;
    }
	
	return $layerslider_slides;
}
endif;

if ( ! function_exists( 'penguin_get_revslider' ) ) :
/**
 * Get option for revslider
 *
 * @since penguin 6.0
 */
function penguin_get_revslider(){
	$revslider_slides = array();
	$revslider_slides[0] = __('Select a slider',Penguin::$THEME_NAME);
	
	 // Get WPDB Object
    global $wpdb;

    // Table name
    $table_name = $wpdb->prefix . "revslider_sliders";
	
	$sql = "show tables like '$table_name'";
	
	$table = $wpdb->get_var($sql);

	// have no rev slider 
	if($table != $table_name) return $revslider_slides;
	
    // Get sliders
    $sliders = $wpdb->get_results( "SELECT * FROM $table_name ORDER BY id LIMIT 100" );
 
    // Iterate over the sliders
    foreach($sliders as $key => $item) {
 		$revslider_slides[$item->id] = '#'.$item->id . ' - ' .$item->title;
    }
	
	return $revslider_slides;
}
endif;

if ( ! function_exists( 'penguin_get_wpml_switcher' ) ) :
/**
 * Get option  for wpml
 *
 * @since penguin 6.0
 */
function penguin_get_wpml_switcher(){
	if (function_exists( 'icl_get_languages' ) && function_exists('icl_disp_language')) {
		$languages = icl_get_languages('skip_missing=1');
		
		if(!empty($languages)){
			
			$lang_active = '';
			$lang_list = '<ul class="sub-menu">';
			
			foreach($languages as $l){

				if($l['active']){ 
					$lang_active = '<a href="#"><i class="fa fa-globe"></i>'.$l['native_name'].'</a>';
				}
				$lang_list .= '<li>';

				if(!$l['active']){
					$lang_list .= '<a href="'.$l['url'].'">';
				}else{
					$lang_list .=  '<span>';
				}
				
				if($l['country_flag_url']){
					$lang_list .= '<img src="'.$l['country_flag_url'].'" height="12" alt="'.$l['language_code'].'" width="18" />';				
				}
				$lang_list .=  $l['native_name'];
			
				if(!$l['active']){
					$lang_list .= '</a>';
				}else{
					$lang_list .=  '</span>';
				}
				$lang_list .= '</li>';
			}
			$lang_list .= '</ul>';
			
			return '<li class="wpml">'.$lang_active.$lang_list.'</li>';
		}
	}
	return '';
}
endif;