<?php 

global $SCHAT, $wpdb;

// Triggable?
$triggable = ( !empty( $option['triggable'] ) ) ? ' data-triggable="' . $option['triggable'] . '" class="schat-opts-triggable hide-if-js"' : ''; 


// Check PHP sessions work?
if( SCHAT_PHP_SESSIONS ) {
	
	// Add test session variable
	$SCHAT->session->set( 'SCHAT_opt_test', 1 );

	$status = '<button id="SCHAT_check_sessions" class="button">' . __( 'Check', 'schat' ) . '</button>'
			 .'<span id="schat_session_ntf" class="description" style="color:#999;">' . __( 'You are using <strong>PHP sessions</strong>. Please click "Check" button to ensure that sessions really work!', 'schat' ) . '<br>' . __( 'If you want to store session data to database, add the code below into <strong>wp-config.php</strong>.', 'schat' ) . "<br><code>define( 'SCHAT_PHP_SESSIONS', false );</code></span>";

} else {

	$count = $wpdb->get_var( "SELECT count(*) FROM $wpdb->options WHERE option_name LIKE '_wp_session%'" );
	$status = '<button id="SCHAT_clean_sessions" class="button">' . __( 'Clean sessions', 'schat' ) . " ($count)</button>"
			 .'<span id="schat_session_ntf" class="description" style="color:#999;">' . __( 'Session data storing to database.', 'schat' ) . '</span>';
}

?>

<tr<?php echo $triggable; ?>>
	<th scope="row"><label for="schat-opts-field-<?php echo $option['id']; ?>"><?php _e( 'Sessions', 'schat' ); ?></label></th>
	<td>
		<?php
		echo $status; 
		?>
	</td>
</tr>