/*!
 * Screets Screets Live Chat Options
 * Author: @screetscom
 *
 * COPYRIGHT (c) 2016 Screets. All rights reserved.
 * This  is  commercial  software,  only  users  who have purchased a valid
 * license  and  accept  to the terms of the  License Agreement can install
 * and use this program.
 */

jQuery(document).ready(function($) {

	// First check if settings reseted correctly! 
	// If not, reset it manually!
	_check = $('input:radio[name=widget_position]:checked').val();
	if( _check === undefined ) {
		window.location.replace( $('.schat-opts-reset').attr('href') );
	}
	// Tooltip
	$('a[rel=tipsy]').tipsy({fade: false, gravity: 's'});

	// Autosize
	$('.schat-autosize').autosize({
		append: ''
	});

	/**
	 * Preview
	 */
	var widget_position,
		base_anim,

		schat_widget = $('.schat-widget'),
		schat_header = $('.schat-header'),
		schat_body = $('.schat-body'),
		schat_btn = $('.schat-chat-btn'),
		schat_form_button = $('.schat-form-btn'),
		schat_online_button = $('.schat-online-btn'),
		schat_offline_button = $('.schat-offline-btn'),
		schat_online = $('.schat-online'),
		schat_offline = $('.schat-offline'),
		schat_popup_reply = $('.schat-reply-input'),
		
		schat_btn_title = $('.schat-chat-btn .schat-title'),
		schat_btn_ico = $('.schat-chat-btn .schat-ico-chat'),
		schat_btn_arrow = $('.schat-chat-btn ._ico-arrow'),

		schat_f_name = $('#SCHAT_offline_row_name'),
		schat_f_email = $('#SCHAT_offline_row_email'),
		schat_f_phone = $('#SCHAT_offline_row_phone'),
		schat_f_msg = $('#SCHAT_offline_row_msg'),
		schat_send_btn = $('#SCHAT_offline_send');
	
		last_preview_mode = 'online_button';


	// Check if we should use white color?
	function schat_use_white(c) {
			c = c.substring(1),      // strip #
			rgb = parseInt(c, 16),   // convert rrggbb to decimal
			r = (rgb >> 16) & 0xff,  // extract red
			g = (rgb >>  8) & 0xff,  // extract green
			b = (rgb >>  0) & 0xff,  // extract blue

			luma = 0.2126 * r + 0.7152 * g + 0.0722 * b; // per ITU-R BT.709

		if ( luma < 180 )
		    return true; // use white
		
		return false; // use black
	}

	// Update preview
	function schat_update_preview() {

		if( _check === undefined ) return;

		var	base_skin = $('input:radio[name=base_skin]:checked').val(),
			widget_size = $('#schat-opts-field-widget_width').val(),
			primary_color = $('#schat-opts-field-primary_color').val(),
			link_color = $('#schat-opts-field-link_color').val(),
			btn_width = $('#schat-opts-field-btn_width').val(),
			when_online = $('#schat-opts-field-when_online').val(),
			when_offline = $('#schat-opts-field-when_offline').val(),
			offline_body = $('#schat-opts-field-offline_body').val(),
			default_radius = $('#schat-opts-field-radius').val() + $('#schat-opts-field-2-radius option:selected').val(),
			reply_pos = $('input:radio[name=reply_pos]:checked').val(),
			popup_reply_ph = $('#schat-opts-field-popup_reply_ph').val(),
			f_name_label = $('#schat-opts-field-f_name_label').val(),
			f_email_label = $('#schat-opts-field-f_email_label').val(),
			f_phone_label = $('#schat-opts-field-f_phone_label').val(),
			f_msg_label = $('#schat-opts-field-f_msg_label').val(),
			send_btn = $('#schat-opts-field-f_send_btn').val(),
			sel_name = $('#schat-opts-field-f_name option:selected').val(),
			sel_email = $('#schat-opts-field-f_email option:selected').val(),
			sel_phone = $('#schat-opts-field-f_phone option:selected').val(),
			comp_avatar = $('#schat-opts-field-default_avatar').val(),
			avatar_size = $('#schat-opts-field-avatar_size').val(),
			avatar_radius = $('#schat-opts-field-avatar_radius').val();
			

		// Update widget position
		widget_position = $('input:radio[name=widget_position]:checked').val().split('-');

		// Default Radius styles
		var radius_bottom = '0 0 ' + default_radius + ' ' + default_radius,
			radius_top = default_radius + ' ' + default_radius + ' 0 0';

		// Update border-radius for fixed skin
		if( base_skin == 'fixed' ) {

			if( widget_position[0] == 'top' ) {
				var radius = radius_bottom;
				radius_top = 0;
			} else {
				var radius = radius_top;
				radius_bottom = 0;
			}
		
		} else {
			var radius = default_radius;
		}

		// Get header foreground
		if( schat_use_white(primary_color) )
			var title_color = '#ffffff';
		else
			var title_color = '#444444';

		// Update standart header
		schat_header.css('color', title_color)
				 .css('background-color', primary_color)
				 .css('border-radius', radius_top);

		// Add reply box class
		schat_online.removeClass('schat-reply-top schat-reply-bottom').addClass('schat-reply-' + reply_pos);

		// First hide reply box
		$('.schat-cnv-reply, .schat-cnv').hide();

		// Display reply box
		$('#SCHAT_reply_' + reply_pos + ', #SCHAT_cnv_' + reply_pos).show();

		// Update body and widget
		schat_body.css('border-radius', radius_bottom);

		// Update chat button width
		schat_btn.css('color', title_color)
				 .css('background-color', primary_color)
				 .css('border-radius', radius);

		// Set button arrow position
		if( widget_position[0] == 'top' )
			schat_btn_arrow.addClass('schat-ico-arrow-down').removeClass('schat-ico-arrow-up');
		else
			schat_btn_arrow.addClass('schat-ico-arrow-up').removeClass('schat-ico-arrow-down');

		// Show button title
		if( $('#schat-opts-field-chat-btn-group-show_title').prop('checked') ) {
			schat_btn_title.show();
			schat_btn.removeClass('schat-no-title');

		} else {
			schat_btn_title.hide();
			schat_btn.addClass('schat-no-title');
		}
		
		// Show button icon
		if( $('#schat-opts-field-chat-btn-group-show_icon').prop('checked') ) {
			schat_btn_ico.show();
			schat_btn.removeClass('schat-no-ico');
		} else {
			schat_btn_ico.hide();
			schat_btn.addClass('schat-no-ico');
		}

		// Show button arrow
		if( $('#schat-opts-field-chat-btn-group-show_arrow').prop('checked') )
			schat_btn_arrow.show();
		else
			schat_btn_arrow.hide();

		// Update popup reply input
		schat_popup_reply.attr('placeholder', popup_reply_ph );

		// Get form send btn foreground
		if( schat_use_white(link_color) )
			var send_btn_fg = '#ffffff';
		else
			var send_btn_fg = '#444444';

		// Update form buttons
		schat_form_button.css('color', send_btn_fg)
					  .css('background-color', link_color);

		// Update window titles
		schat_online.find('.schat-header > .schat-title').html(when_online);
		schat_offline.find('.schat-header > .schat-title').html(when_offline);

		// Update offline body
		schat_offline.find('.schat-offline-form .schat-lead').html(offline_body);

		// Update offline form
		schat_f_name.find('.schat-title').html( f_name_label );
		schat_f_name.find('input').attr( 'placeholder', f_name_label );
		if( sel_name == 'hidden' ) schat_f_name.hide();

		schat_f_email.find('.schat-title').html( f_email_label );
		schat_f_email.find('input').attr( 'placeholder', f_email_label );
		if( sel_email == 'hidden' ) schat_f_email.hide();

		schat_f_phone.find('.schat-title').html( f_phone_label );
		schat_f_phone.find('input').attr( 'placeholder', f_phone_label );
		if( sel_phone == 'hidden' ) schat_f_phone.hide();

		schat_f_msg.find('.schat-title').html( f_msg_label );
		schat_f_msg.find('textarea').attr( 'placeholder', f_msg_label );

		schat_send_btn.html( send_btn );

		// Update button sizes
		if( btn_width > 0 ) {
			schat_online_button.width( btn_width );
			schat_offline_button.width( btn_width );
		} else {
			schat_online_button.width('');
			schat_offline_button.width('');
		}

		
		// Update chat button online title
		schat_online_button.find('.schat-title').html( when_online );

		// Update chat button offline title
		schat_offline_button.find('.schat-title').html( when_offline );

		// Update widget wrapper
		schat_widget.width( widget_size )
				 .css( 'border-radius', default_radius );


		// Company avatar
		if( comp_avatar.length )
			$( '.schat-company-avatar' ).attr( 'src', comp_avatar );

		// Change avatar size
		$('.schat-cnv .schat-avatar, .schat-cnv .schat-avatar.schat-img img').css( 'width', parseInt( avatar_size ) );
		$('.schat-cnv-line:not(.schat-you) .schat-cnv-msg').css( 'margin-left', parseInt(avatar_size)+10 );

		// Change avatar radius
		$('.schat-cnv .schat-avatar.schat-img img').css( 'border-radius', avatar_radius + 'px' );

	}


	// Animate widget
	$('#schat-opts-field-anim').change(function() {
		// Update base animation
		base_anim = $(this).find('option:selected').val();

		schat_animate();
	});

	// Animate button
	$('#schat-opts-btn-anim').click(function(e) {
		e.preventDefault();
		$('#schat-opts-field-anim').trigger('change');
	});

	// Animate current widget
	function schat_animate() {

		var direction,
			pos = widget_position[0];

		var speed_up = $('#schat-opts-field-anim-group-hinge').prop('checked');

		switch( last_preview_mode ) {
			case 'online_button': 
				var obj = schat_online_button;
				break;

			case 'offline_button': 
				var obj = schat_offline_button;
				break;

			case 'online': 
			case 'offline': 
				var obj = schat_widget;
				break;
		}

		// Up or Down?
		switch(base_anim) {
			case 'bounceIn':
			case 'fadeIn':
				if( pos == 'top' ) 
					direction = 'Down';
				else
					direction = 'Up';
			break;
		}

		if( speed_up )
			obj.addClass('schat-' + base_anim + direction + ' schat-anim');
		else
			obj.addClass('schat-' + base_anim + direction + ' schat-anim schat-hinge');

		// Remove CSS animation
		setTimeout( function() {
			obj.removeClass('schat-anim schat-hinge schat-' + base_anim + direction);
		}, 1500);

	}

	// Update changes
	$('#schat-opts-options-form input, #schat-opts-options-form textarea').on('change keyup blur', function() {
		schat_update_preview();
	});


	// Focus on reply area
	$('.schat-cnv-input').click(function() {
		$(this).find('.schat-reply-input').focus().autosize( { append: '' } );
	});

	// Clean reply box when click enter
	schat_popup_reply.keydown( function( e ) {

		if ( e.keyCode == 13 && !e.shiftKey ) {

			e.preventDefault();

			$(this).val('').trigger('autosize.resize');
		}

	});


	/**
	 * Change preview (WP 3.8+)
	 */
	$('.schat-preview-icons li').click(function() {

		var mode = $(this).data('id');

		// Hide last preview mode
		$('#SCHAT_preview_' + last_preview_mode).removeClass('_visible');

		// Show up current mode
		$('#SCHAT_preview_' + mode).addClass('_visible');

		// Deactivate last icon
		$('#ico_' + last_preview_mode ).removeClass('active');
		
		// Activate icon
		$(this).addClass('active');

		// Update title
		$('#schat_preview_title').html( $(this).attr('title') + ':');

		// Autosize
		if( mode === 'online' )
			$('.schat-reply-input').focus().autosize( { append: '' } ).trigger('autosize.resize');

		// Update last preview mode
		last_preview_mode = mode;

	});

	/**
	 * Change preview (old WP versions)
	 */
	$('.schat-preview').change(function() {

		var mode = $(this).find(':selected').val();
		
		// Hide last preview mode
		$('#SCHAT_preview_' + last_preview_mode).removeClass('_visible');

		// Show up current mode
		$('#SCHAT_preview_' + mode).addClass('_visible');

		// Update last preview mode
		last_preview_mode = mode;
	});


	schat_update_preview();


	// ########## Tabs ##########

	// Nav tab click
	$('#schat-opts-tabs span').click(function(event) {
		// Hide tips
		$('.schat-opts-spin, .schat-opts-success-tip').hide();
		// Remove active class from all tabs
		$('#schat-opts-tabs span').removeClass('nav-tab-active');
		// Hide all panes
		$('.schat-opts-pane').hide();
		// Add active class to current tab
		$(this).addClass('nav-tab-active');
		// Show current pane
		$('.schat-opts-pane:eq(' + $(this).index() + ')').show();
		// Save tab to cookies
		sunriseCreateCookie( pagenow + '_last_tab', $(this).index(), 365 );
	});

	// Auto-open tab by link with hash
	if ( sunriseStrpos( document.location.hash, '#tab-' ) !== false )
		$('#schat-opts-tabs span:eq(' + document.location.hash.replace('#tab-','') + ')').trigger('click');
	// Auto-open tab by cookies
	else if ( sunriseReadCookie( pagenow + '_last_tab' ) != null )
		$('#schat-opts-tabs span:eq(' + sunriseReadCookie( pagenow + '_last_tab' ) + ')').trigger('click');
	// Open first tab by default
	else
		$('#schat-opts-tabs span:eq(0)').trigger('click');
	
	$('#schat-opts-tabs span').css( 'visibility', 'visible' );
	

	var working = false,
		btn_text = '';

	/**
	 * Create databases
	 */
	$('#SCHAT_create_db').click(function(e) {
		e.preventDefault();

		var btn = $(this);

		if( working ) return;

		$(this).html( 'Please wait...' );

		$.post( schat.ajax_url + '?action=schat_ajax_callback&mode=create_db', null, function( r ) {

			// Redirect if possible
			if( r.redirect )
				window.location.replace( r.redirect );



		}, 'json' )
		.fail(function (jqXHR) {
			
			// Log error
			console.log(jqXHR);
			
			return false;

		});

	});

	/**
	 * Check security
	 */
	 $('#SCHAT_upd_security').click(function(e) {
		e.preventDefault();

		var btn = $(this);

		if( working ) return;

		$(this).html( 'Please wait...' );

		$.post( schat.ajax_url + '?action=schat_ajax_callback&mode=update_security', null, function( r ) {

			// Redirect if possible
			if( r.redirect )
				window.location.replace( r.redirect );



		}, 'json' )
		.fail(function (jqXHR) {
			
			// Log error
			console.log(jqXHR);
			
			return false;

		});

	});

	/**
	 * Clean realtime data
	 */
	 $('#SCHAT_clean_data').click( function(e) {

	 	e.preventDefault();

		var btn = $(this);

		if( working ) return;

		$(this).html( 'Please wait! This may take awhile...' );

		$.post( schat.ajax_url + '?action=schat_ajax_callback&mode=clean_data', null, function( r ) {

			if( r.success === 1 ) {

				btn.css('color', 'green').html('Cleaned!');

			} else {
				btn.css('color', 'red').html("Something went wrong!");
			}



		}, 'json' )
		.fail(function (jqXHR) {
			
			// Log error
			console.log(jqXHR);
			
			return false;

		});

	 });

	/**
	 * Check if php sessions work
	 */
	 $('#SCHAT_check_sessions').click( function(e) {
		
		e.preventDefault();

		var btn = $(this);

		if( working ) return;

		$(this).html( 'Please wait...' );

		$.post( schat.ajax_url + '?action=schat_ajax_callback&mode=check_sessions', null, function( r ) {

			if( r.success === 1 ) {

				btn.css('color', 'green').html('<span style="color:green">Works!</span>');

			} else {
				btn.css('color', 'green').html("<span style='color:red'>Doesn't work</span>");
				$('#schat_session_ntf').html( "Add the code below into your <strong>wp-config.php</strong> file: <br /><pre>define( 'SCHAT_PHP_SESSIONS', false );</pre> " );
			}



		}, 'json' )
		.fail(function (jqXHR) {
			
			// Log error
			console.log(jqXHR);
			
			return false;

		});

	});

	/**
	 * Clean sessions
	 */
	 $('#SCHAT_clean_sessions').click( function(e) {
		
		e.preventDefault();

		var btn = $(this);

		if( working ) return;

		$(this).html( 'Please wait...' );

		$.post( schat.ajax_url + '?action=schat_ajax_callback&mode=clean_sessions', null, function( r ) {

			// Redirect if possible
			if( r.redirect ) {

				btn.css('color', 'green').html('Cleared successfully!');

				// window.location.replace( r.redirect );

			} else
				btn.html( r.error );



		}, 'json' )
		.fail(function (jqXHR) {
			
			// Log error
			console.log(jqXHR);
			
			return false;

		});

	});


	


	// ########## Ajaxed form ##########

	$('#schat-opts-options-form').ajaxForm({
		beforeSubmit: function() {
			$('.schat-opts-success-tip').hide();
			$('.schat-opts-spin').fadeIn(200);
			$('.schat-opts-submit').attr('disabled', true);
		},
		success: function() {
			$('.schat-opts-spin').hide();
			$('.schat-opts-success-tip').show();
			setTimeout(function() {
				$('.schat-opts-success-tip').fadeOut(200);
			}, 2000);
			$('.schat-opts-submit').attr('disabled', false);

			// Refresh page
			location.reload();
		}
	});


	// ########## Reset settings confirmation ##########

	$('.schat-opts-reset').click(function() {
		if (!confirm($(this).attr('title')))
			return false;
		else
			return true;
	});


	// ########## Notifications ##########

	$('.schat-opts-notification').css({
		cursor: 'pointer'
	}).on('click', function(event) {
		$(this).fadeOut(100, function() {
			$(this).remove();
		});
	});


	// ########## Triggables ##########

	// Select
	$('tr[data-trigger-type="select"] select').each(function(i) {

		var // Input data
		name = $(this).attr('name'),
		index = $(this).find(':selected').index();

		//alert( name + ' - ' + index );

		// Hide all related triggables
		$('tr.schat-opts-triggable[data-triggable^="' + name + '="]').hide();

		// Show selected triggable
		$('tr.schat-opts-triggable[data-triggable="' + name + '=' + index + '"]').show();

		$(this).change(function() {

			index = $(this).find(':selected').index();

			// Hide all related triggables
			$('tr.schat-opts-triggable[data-triggable^="' + name + '="]').hide();

			// Show selected triggable
			$('tr.schat-opts-triggable[data-triggable="' + name + '=' + index + '"]').show();
		});
	});

	// Radio
	$('tr[data-trigger-type="radio"] .schat-opts-radio-group').each(function(i) {

		var // Input data
		name = $(this).find(':checked').attr('name'),
		index = $(this).find(':checked').parent('label').parent('div').index();

		// Hide all related triggables
		$('tr.schat-opts-triggable[data-triggable^="' + name + '="]').hide();

		// Show selected triggable
		$('tr.schat-opts-triggable[data-triggable="' + name + '=' + index + '"]').show();

		$(this).find('input:radio').each(function(i2) {

			$(this).change(function() {

				alert();

				// Hide all related triggables
				$('tr.schat-opts-triggable[data-triggable^="' + name + '="]').hide();

				// Show selected triggable
				$('tr.schat-opts-triggable[data-triggable="' + name + '=' + i2 + '"]').show();
			});
		});
	});


	// ########## Clickouts ##########

	$(document).on('click', function(event) {
		if ( $('.schat-opts-prevent-clickout:hover').length == 0 )
			$('.schat-opts-clickout').hide();
	});


	// ########## Upload buttons ##########

	$('.schat-opts-upload-button').click(function(event) {

		// Define upload field
		window.sunrise_current_upload = $(this).attr('rel');

		// Show thickbox with uploader
		tb_show('', 'media-upload.php?type=image&amp;TB_iframe=true');

		// Prevent click
		event.preventDefault();
	});

	window.send_to_editor = function(html) {

		var url;

		if ( jQuery(html).filter('img:first').length > 0 )
			url = jQuery(html).filter('img:first').attr('src');
		else
			url = jQuery(html).filter('a:first').attr('href');

		// Update upload textfield value
		$('#schat-opts-field-' + window.sunrise_current_upload).val(url);

		// Hide thickbox
		tb_remove();
	}


	// ########## Color picker ##########

	$('.schat-opts-color-picker-preview').each(function(index) {
		$(this).farbtastic('.schat-opts-color-picker-value:eq(' + index + ')');
		$('.schat-opts-color-picker-value:eq(' + index + ')').focus(function(event) {
			$('.schat-opts-color-picker-preview').hide();
			$('.schat-opts-color-picker-preview:eq(' + index + ')').show();
		});
	});


	// Check if Woocommerce installed
	if( !schat_opts.wc_installed ) {
		$('#schat-opts-field-display-chatbox-group-woocomerce_pages')
			.attr("disabled", true)
			.parent()
			.css( 'color', '#ccc' );
	}
	
});


// ########## Cookie utilities ##########

function sunriseCreateCookie(name,value,days){
	if(days){
		var date=new Date();
		date.setTime(date.getTime()+(days*24*60*60*1000));
		var expires="; expires="+date.toGMTString()
	}else var expires="";
	document.cookie=name+"="+value+expires+"; path=/"
}
function sunriseReadCookie(name){
	var nameEQ=name+"=";
	var ca=document.cookie.split(';');
	for(var i=0;i<ca.length;i++){
		var c=ca[i];
		while(c.charAt(0)==' ')c=c.substring(1,c.length);
		if(c.indexOf(nameEQ)==0)return c.substring(nameEQ.length,c.length)
	}
	return null
}


// ########## Strpos tool ##########

function sunriseStrpos( haystack, needle, offset) {
	var i = haystack.indexOf( needle, offset );
	return i >= 0 ? i : false;
}