/*!
 * Screets Screets Live Chat Console
 * Author: @screetscom
 *
 * COPYRIGHT (c) 2016 Screets. All rights reserved.
 * This  is  commercial software,  only  users  who have purchased a valid
 * license  and  accept to the terms of the  License Agreement can install
 * and use this program.
 */

(function ($) {
	
	$(document).ready(function() {

		var last_cnv_id = null,
			last_user_id = null,
			last_msg_id = null,
			ls_ntf = $('#SCHAT_ls_ntf'),
			conn_btn = $('#SCHAT_connect'),
			checked_user_ids = [];

		// Show welcome popup
		fn_show_welcome_popup = function() {

			// Use default popup content
			$('#SCHAT_popup_cnv').removeClass()
							  .addClass( 'schat-popup-content schat-welcome' )
							  .empty();

		}

		/**
		 * Use CX plugin
		 */
		$('body').schat({
			app_id 			: schat.app_id,
			user_info 		: {
				id 		: schat.user_id,
				name 	: schat.user_name,
				email 	: schat.user_email
			},
			render 			: false,
			company_avatar 	: schat.company_avatar,
			debug 			: true,

			// Before load
			before_load: function() {

				var self = this;

				// Update login form data
				this.data.current_form = {
					name 		: schat.user_name,
					email 		: schat.user_email,
					gravatar 	: schat.user_email_hash
				}

				conn_btn.click(function(e) {
					e.preventDefault();
					
					// Display "Connecting" message
					ls_ntf.show().html( self.opts.msg.connecting + '...' );

					// If already connected, don't try it again
					if( !$(this).data( 'logged' ) )
						self.login( true );
					
					else if( $(this).data( 'status', 'online' ) ) {
						self.be_offline();
					} 
					
				});
			},


			// Current user is offline
			offline : function() {

				// Play sound
				this.play_sound( 'schat-disconnected' );

				// Display "Connected" message
				ls_ntf.html( "You're offline!" );

				// Show offline button
				conn_btn.html( '<span class="schat-ico schat-ico-online" style="color:#e54045;"></span> ' + this.opts.msg.offline_btn ).data('logged', 0).data('status', 'offline').addClass('schat-offline').removeClass('schat-online button-disabled');

				// Update console class
				$('#SCHAT_console').removeClass( 'schat-online' ).addClass( 'schat-offline' );

			},

			// Authentication error
			auth_error : function( error ) {

				// Enable button
				conn_btn.removeClass('button-disabled');
				
				// Display error
				ls_ntf.hide().html( error.message ).fadeIn(200);

			},

			// Authenticated in Firebase, not logged in yet
			auth : function() {
				
				// Display "Connected" message
				ls_ntf.html( schat.msgs.you_offline );

				// Show connect button
				conn_btn.html( schat.msgs.connect ).data('logged', 0).addClass('schat-offline').removeClass('schat-online button-disabled');

			},

			// Logged in successfully
			logged_in: function( user ) {

				// Play sound
				this.play_sound( 'schat-connected' );

				// Listen messages
				this.listen_msgs();

				// Enable button
				conn_btn.removeClass('button-disabled');
				
				// Hide notification on users list
				ls_ntf.hide().empty();

				// Update online button
				conn_btn.html( '<span class="schat-ico schat-ico-online" style="color:#33cc33"></span> ' + this.opts.msg.online_btn ).data('logged', 1).data('status', 'online').addClass('schat-online').removeClass('schat-offline button-disabled');

				// Update console class
				$('#SCHAT_console').addClass( 'schat-online' ).removeClass( 'schat-offline' );

			},

			// Logged out
			logged_out: function( logout_msg ) {

				// Play sound
				this.play_sound( 'schat-disconnected' );
				
				// Display "Connected" message
				ls_ntf.html( "Logged out!" );

				// Show connect button
				conn_btn.html( schat.msgs.connect ).data('logged', 0).data('status', 'offline').addClass('schat-offline').removeClass('schat-online button-disabled');

				// Show welcome popup
				fn_show_welcome_popup();

				// Update console class
				$('#SCHAT_console').removeClass( 'schat-online' ).addClass( 'schat-offline' );

			},

			// New user is online now
			user_online : function( user ) {

				if( $.inArray( user.id, checked_user_ids ) && user.id != this.data.user.id ) { // If operator didn't logged out itself

					// Play sound
					this.play_sound( 'schat-online' );

					// Notify user
					this.notify( schat.msgs.new_user_online, user.name + ' (' + user.type + ')', null, 'user_online' );

					// Add user in checked users
					checked_user_ids.push( user.id );

				}


			},

			// A user appeared offline
			user_offline : function( user ) {

				// Play sound if operator didn't logged out itself
				if( user.id != this.data.user.id )
					this.play_sound( 'schat-offline' );

			},

			// New message sent to any online user
			new_msg : function( msg ) {

				var obj_user = $( '#SCHAT_ls_usr_' + msg.user_id ),
					obj_count = obj_user.find( '.schat-count' ),
					total_msg = parseInt( obj_user.data( 'count' ) );

				// Update total msg if it isn't old message and not user's own message
				if( !msg.old_msg && !msg.first_load && msg.user_id != this.data.user.id ) {

					total_msg = total_msg + 1;

					// Update user item in the list
					obj_user.addClass( 'schat-new-msg' ).data( 'count', total_msg );

					// Update count
					obj_count.html( '(' + total_msg + ')' );

					// Play sound
					this.play_sound( 'schat-new-msg' );

					// Notify user
					this.notify( schat.msgs.new_msg, msg.name + ': ' + msg.msg, null, 'new_msg' );

				}

				// Update current conversation area
				if( this.data.user.cnv_id == msg.cnv_id ) {

					// Remove notification
					$( '#SCHAT_load_msg_0' ).remove();
					
					// Render message
					this.add_msg( msg, last_user_id, last_msg_id );

					// Update last user id
					last_user_id = msg.user_id;

					// Update last message id
					if( last_user_id != msg.user_id || !last_msg_id )
						last_msg_id = msg.msg_id;

				}

			},

			// Conversation messages loaded
			cnv_msgs_loaded : function( total_msgs ) {
				
				if( !total_msgs )
					$( '#SCHAT_load_msg_0' ).html( this.opts.msg.no_msg + '.' ); // No messages found
				else
					$( '#SCHAT_load_msg_0' ).empty(); // Hide load msg in anyway

			},

			// After load
			after_load : function() {

				var self = this,
					working = false;

				// Autosize reply input when focussed
				$(document).on('focus', '#SCHAT_cnv_reply_0', function() {
					$(this).autosize({
						append: ''
					});
				});

				/**
				 * When click user on the users list
				 */
				$( document ).on( 'click', '#SCHAT_users li', function() {

					var obj_user = $(this);

					// Get user data
					self.get_user_data( $(this).data( 'id' ), function( user ) {

						// Deactivate last active user
						if( self.data.active_user_id )
							$( '#SCHAT_ls_usr_' + self.data.active_user_id ).removeClass( 'schat-active' );

						// Clean highlights and count
						obj_user.addClass( 'schat-active' ).removeClass( 'schat-new-msg' ).data( 'count', 0 ).find( '.schat-count' ).empty();

						// Update current conversation
						$( '#SCHAT_tab_username' ).html( obj_user.data( 'name' ) );

						// Popup params
						var popup_data = {
							box_id 		: 0,
							reply_ph 	: self.opts.msg.reply_ph,
							load_msg 	: self.opts.msg.please_wait + '...'
						};

						// Show user popup
						$('#SCHAT_popup_cnv').removeClass('schat-welcome').html( self.render( 'online-basic', popup_data ) );

						// Autosize reply input
						$('#SCHAT_cnv_reply_0').focus();

						// Prepare user info sidebar
						if( obj_user.data( 'id' ) === self.data.user.id ) { // User opened itself conversation

							// Don't show meta tools
							var user_html = '<ul><li><strong>IP</strong> <span class="schat-user-meta-ip">' + user.ip + '</span></li><li><strong>User Info</strong><span class="schat-user-meta-email"><a href="mailto:' + user.email + '">' + user.email + '</a></span></li></ul>';
						
						} else {
							
							var user_html = '<div class="schat-user-meta-tools"><button id="SCHAT_save" data-cnv-id="' + obj_user.data( 'cnv-id' ) + '" class="button button-small schat-ico schat-ico-save"></button> <button id="SCHAT_end_chat" data-cnv-id="' + obj_user.data( 'cnv-id' ) + '" class="button button-small schat-tooltip">' + self.opts.msg.end_chat + '<span>' + schat.msgs.save_end_chat + '</span></button><br /><small id="SCHAT_user_meta_ntf"></small></div> <small class="description" style="display: block; color:#999; margin-bottom: 15px;">' + schat.msgs.save_note + '</small><ul><li><strong>IP</strong> <span class="schat-user-meta-ip">' + user.ip + '</span></li><li><strong>User Info</strong><span class="schat-user-meta-email"><a href="mailto:' + user.email + '">' + user.email + '</a></span></li></ul>';
						}

						// Update additional info
						if( user.current_page )
							user_html = user_html + '<div id="SCHAT_popup_info_0"><strong><i class="schat-ico-preview"></i> Active Page:</strong><a id="SCHAT_active_page" href="' + user.current_page + '" target="_blank"><span>' + user.current_page + '</span></a></div>';

						// Update user info
						$('#SCHAT_cnv_user_info_0').html( user_html );


						// Set conversation area
						self.objs.cnv = $( '#SCHAT_cnv_' + self.data.box_id );

						// Update current conversation id
						// Now operator's current conversation is the same with the user operator talks
						self.data.user.cnv_id = obj_user.data('cnv-id');

						// Set last active user
						self.data.active_user_id = obj_user.data('id');


						// Reload conversation
						self.reload_cnv( obj_user.data('cnv-id') );

						// Manage reply box
						self.manage_reply_box( last_cnv_id );

						// Update last conversation id
						last_cnv_id = obj_user.data('cnv-id');


						// Resize window
						$(window).trigger('resize');
						
					});

				});


				/**
				 * End chat
				 */
				$(document).on( 'click', '#SCHAT_save, #SCHAT_end_chat', function(e) {

					var btn = $(this),
						ntf = $('#SCHAT_user_meta_ntf'),
						delete_from_app = $(this).attr('id') === 'SCHAT_end_chat' ? true : false;

					// Don't allow more than one clicks
					if( working ) {
						ntf.html( self.opts.msg.please_wait + '...' ); // Waiting for the next request
						return;
					}

					working = true;

					// Disable button
					$(this).addClass( 'button-disabled' );

					// Display saving notification on user metabar
					ntf.html( schat.msgs.saving + '...' );

					// Save user data
					self.save_user_data( $(this).data( 'cnv-id' ), delete_from_app, function( r ) {

						working = false; // Not working anymore

						// Reactivate button
						btn.removeClass( 'button-disabled' );

						// Update notification
						if( r.error )
							ntf.html( r.error );
						else
							ntf.html( r.msg ); // Successfully saved!

						// Clean notification after a while
						setTimeout( function() {

							ntf.fadeOut(2000);

						}, 1000 );

						// Show welcome popup if user session ended
						if( delete_from_app ) {

							setTimeout( function() {

								fn_show_welcome_popup();

							}, 3000 );

						}

					});

				});

				// Remove active user highlight when visitor already mouseover on the conversation
				$('#SCHAT_popup_content').mouseover( function() {

					// Remove highlight and reset count
					$('#SCHAT_ls_usr_' + self.data.active_user_id ).removeClass( 'schat-new-msg' )
													  .data( 'count', 0 ) // Reset count
													  .find( '.schat-count' ).empty();

					
				});


				// Update last online times every minute
				setInterval( function() {

					$( '.schat-last-online' ).each( function( i ) {

						$(this).html( self.timeago( $(this).data( 'time' ) ) );

					});

				}, 60000 );

				window.onbeforeunload = function (e) {
					var e = e || window.event;

					//IE & Firefox
					if (e) {
						e.returnValue = schat.msgs.ntf_close_console;
					}

					// For Safari
					return schat.msgs.ntf_close_console;
				};

			}

		});


		// Align layout
		$(window).resize(function() {

			var win_h = $(window).height();
			var popup_h = win_h - 103;

			// Set tab content heights
			$('#SCHAT_wall .schat-popup-content').height( popup_h );

			// Set conversation popup height
			$('#SCHAT_cnv_0').height( popup_h - 91 );
			
			// Set user meta height
			$('#SCHAT_cnv_user_info_0').height( popup_h - 77 );

			// Set max-height of users list
			$('#SCHAT_users').css( 'max-height', win_h - 201 );

			// Current tab id
			var tab_id = $('#SCHAT_tabs .schat-active a').attr('href');

			// Reply input height
			var reply_h = $(tab_id).find('.schat-cnv-reply').height() + 50;

			// Set height of popups
			$('.schat-cnv').height( popup_h - reply_h );

		}).trigger('resize');



	});

} (window.jQuery || window.Zepto));