<?php
/*
Plugin Name: Logo Showcase - Addon For Visual Composer
Description: A Visual Composer Addon which will allow you to insert a grid, carousel or perspective logo showcase
Version: 1.2.1
Author: Lambert Group
Author URI: http://codecanyon.net/user/LambertGroup/portfolio?ref=LambertGroup
*/


//all the messages
$rand_id=rand(10,999999);

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}


function logo_showcase_addon_vc_map_dependencies() {
	if ( ! defined( 'WPB_VC_VERSION' ) ) {
		$plugin_data = get_plugin_data(__FILE__);
        echo '<div class="updated">
          <p>'.sprintf(__('<strong>%s</strong> requires <strong><a href="http://bit.ly/vcomposer" target="_blank">Visual Composer</a></strong> plugin to be installed and activated on your site.', 'vc_extend'), $plugin_data['Name']).'</p>
        </div>';
	}
}
add_action( 'admin_notices', 'logo_showcase_addon_vc_map_dependencies' );


function logo_showcase_addon_vc_map_init() {
	global $wpdb;
	global $rand_id;
	

	
	
	
	//Create New Param Type 'logo_showcase_attach_media'
			/*add_shortcode_param( 'logo_showcase_attach_media', 'logo_showcase_attach_media_callback', plugins_url() . '/lbg_logo_showcase_addon_visual_composer/assets/new_param_type/attach_media.js');
			function logo_showcase_attach_media_callback( $settings, $value ) {   
				return '<div class="my_param_block">'
				.'<input id="' . esc_attr( $settings['param_name'] ) . '" name="' . esc_attr( $settings['param_name'] ) . '" class="wpb_vc_param_value wpb-textinput ' . esc_attr( $settings['param_name'] ) . ' ' .              esc_attr( $settings['type'] ) . '_field" type="text" value="' . esc_attr( $value ) . '" style="width:70%;" />' .
				'<input name="upload_' . esc_attr( $settings['param_name'] ) . '_button" type="button" id="upload_' . esc_attr( $settings['param_name'] ) . '_button" value="Upload File" style="width:30%;" /> '.'</div>'; // This is html markup that will be outputted in content elements edit form
			}*/


	
	
	vc_map( array(
		'name' => __( 'Logo Showcase', 'js_composer' ),
		'base' => 'logo_showcase',
		"icon" => plugins_url('assets/images/logo_showcase_icon.png', __FILE__), // or css class name which you can reffer in your css file later. Example: "vc_extend_my_class"
		"category" => __('LBG Multimedia Addons', 'js_composer'),
		"description" => __("Grid, carousel or perspective version", 'vc_extend'),	
		'show_settings_on_create' => false,
		'is_container' => true,
		'admin_enqueue_js'      => preg_replace( '/\s/', '%20', plugins_url( 'assets/logo_showcase.js', __FILE__ ) ),
		// This will load extra js file in backend (when you edit page with VC)
		// use preg replace to be sure that "space" will not break logic

		//'admin_enqueue_css'     => preg_replace( '/\s/', '%20', plugins_url( 'assets/admin_enqueue_css.css', __FILE__ ) ),
		'admin_enqueue_css'     => preg_replace( '/\s/', '%20', plugins_url( 'assets/logo_showcase.css', __FILE__ ) ),
		// This will load extra css file in backend (when you edit page with VC)				
		'params' => array(
			array(
				'group' => 'General',
				'type' => 'textfield',
				'heading' => __( 'Player ID', 'js_composer' ),
				'param_name' => 'id',
				'value' => __( "".$rand_id."", "my-text-domain" ),
				'description' => __( "It is automaticaly generated and it has to be unique. You can leave it just like it is.", "js_composer" )
			),
			array(
				'group' => 'General',
				'type' => 'dropdown',
				'heading' => __( 'Type', 'js_composer' ),
				'param_name' => 'type',
				'value' => array(
					'grid' => 'grid',
					'carousel' => 'carousel',
					'perspective (and one-by-one carousel)' => 'perspective'
				)
			),
			array(
				'group' => 'General',
				'type' => 'textfield',
				'heading' => __( 'Width', 'js_composer' ),
				'param_name' => 'width', //width
				'value' => __( "960", "my-text-domain" )
			),
			array(
				'group' => 'General',
				'type' => 'dropdown',
				'heading' => __( 'Center Showcase', 'js_composer' ),
				'param_name' => 'center_plugin',
				'value' => array(				
					'Yes' => 'true',
					'No' => 'false'
				 ),
				'description' => __( "Center the showcase", "js_composer" )
			),
			array(
				'group' => 'General',
				'type' => 'dropdown',
				'heading' => __( 'Responsive', 'js_composer' ),
				'param_name' => 'responsive',
				'value' => array(
					'Yes' => 'true',
					'No' => 'false'					
				  )
			),
			array(
				'group' => 'General',
				'type' => 'dropdown',
				'heading' => __( 'Responsive Relative To Browser', 'js_composer' ),
				'param_name' => 'responsive_relative_to_browser', //responsiveRelativeToBrowser
				'value' => array(
					'No' => 'false',
					'Yes' => 'true'
				  )
			),			
			array(
				'group' => 'General',
				'type' => 'dropdown',
				'heading' => __( 'Thumb link target', 'js_composer' ),
				'param_name' => 'target', //target
				'value' => array(
					'_blank' => '_blank',
					'_self' => '_self'
				  )
			),
			array(
				'group' => 'General',
				'type' => 'dropdown',
				'heading' => __( 'Show Tooltip', 'js_composer' ),
				'param_name' => 'show_tooltip', //showTooltip
				'value' => array(
					'Yes' => 'true',
					'No' => 'false'					
				  )
			),
			array(
				'group' => 'General',
				'type' => 'dropdown',
				'heading' => __( 'Grayscale', 'js_composer' ),
				'param_name' => 'grayscale', //grayscale
				'value' => array(
					'No' => 'false',
					'Yes' => 'true'
				  )
			),
			array(
				'group' => 'General',
				'type' => 'textfield',
				'heading' => __( 'Border Width', 'js_composer' ),
				'param_name' => 'border', //border
				'value' => __( "0", "my-text-domain" )
			),
			array(
				'group' => 'General',            
				'type' => 'colorpicker',
				'heading' => __( "Border Color OFF", "js_composer" ),
				'param_name' => 'border_color_off', //borderColorOFF
				'value' => 'transparent',
				'description' => __( "Choose the color", "js_composer" )
			),
			array(
				'group' => 'General',            
				'type' => 'colorpicker',
				'heading' => __( "Border Color ON", "js_composer" ),
				'param_name' => 'border_color_on', //borderColorON
				'value' => '#FF0000',
				'description' => __( "Choose the color", "js_composer" )
			),
			

			
			
			
			array(
				'group' => 'Only Grid',
				'type' => 'textfield',
				'heading' => __( 'columWidth', 'js_composer' ),
				'param_name' => 'colum_width', //columWidth
				'value' => __( "100", "my-text-domain" )
			),
			array(
				'group' => 'Only Grid',
				'type' => 'textfield',
				'heading' => __( 'Gutter', 'js_composer' ),
				'param_name' => 'gutter', //gutter
				'value' => __( "25", "my-text-domain" )
			),
			array(
				'group' => 'Only Grid',
				'type' => 'textfield',
				'heading' => __( 'Margin Left', 'js_composer' ),
				'param_name' => 'margin_left', //margin_left
				'value' => __( "25", "my-text-domain" )
			),
			array(
				'group' => 'Only Grid',
				'type' => 'textfield',
				'heading' => __( 'Margin Right', 'js_composer' ),
				'param_name' => 'margin_right', //margin_right
				'value' => __( "25", "my-text-domain" )
			),
			array(
				'group' => 'Only Grid',
				'type' => 'textfield',
				'heading' => __( 'Margin Top', 'js_composer' ),
				'param_name' => 'margin_top', //margin_top
				'value' => __( "10", "my-text-domain" )
			),
		
			
			
			

			array(
				'group' => 'Only Carousel',
				'type' => 'dropdown',
				'heading' => __( 'Bottom Navigation Position', 'js_composer' ),
				'param_name' => 'bottom_nav_position', //bottomNavPosition
				'value' => array(
					'center' => 'center',	
					'left' => 'left',					
					'right' => 'right'					
				  )
			),
			array(
				'group' => 'Only Carousel',
				'type' => 'textfield',
				'heading' => __( 'Number Of Thumbs Per Screen', 'js_composer' ),
				'param_name' => 'number_of_thumbs_per_screen', //numberOfThumbsPerScreen
				'value' => __( "0", "my-text-domain" ),
				'description' => __( "If you set it to 0, it will be calculated automatically. You can set a fixed number, for example 3", "js_composer" )  
			),
			

			
			
			array(
				'group' => 'Only Perspective',
				'type' => 'textfield',
				'heading' => __( 'Animation Time', 'js_composer' ),
				'param_name' => 'animation_time', //animationTime
				'value' => __( "0.8", "my-text-domain" ),
				'description' => __( "seconds", "js_composer" )  
			),
			array(
				'group' => 'Only Perspective',
				'type' => 'dropdown',
				'heading' => __( 'Easing', 'js_composer' ),
				'param_name' => 'easing', //easing
				'value' => array(
					'easeOutQuad' => 'easeOutQuad',
					'easeInQuad' => 'easeInQuad',					
					'easeInOutQuad' => 'easeInOutQuad',
					'easeInCubic' => 'easeInCubic',
					'easeOutCubic' => 'easeOutCubic',
					'easeInOutCubic' => 'easeInOutCubic',
					'easeInQuart' => 'easeInQuart',
					'easeOutQuart' => 'easeOutQuart',
					'easeInOutQuart' => 'easeInOutQuart',
					'easeInSine' => 'easeInSine',
					'easeOutSine' => 'easeOutSine',
					'easeOutSine' => 'easeOutSine',
					'easeInExpo' => 'easeInExpo',
					'easeOutExpo' => 'easeOutExpo',
					'easeInOutExpo' => 'easeInOutExpo',
					'easeInQuint' => 'easeInQuint',
					'easeOutQuint' => 'easeOutQuint',
					'easeInOutQuint' => 'easeInOutQuint',
					'easeInCirc' => 'easeInCirc',
					'easeOutCirc' => 'easeOutCirc',
					'easeInOutCirc' => 'easeInOutCirc',
					'easeInElastic' => 'easeInElastic',
					'easeOutElastic' => 'easeOutElastic',
					'easeInOutElastic' => 'easeInOutElastic',
					'easeInBack' => 'easeInBack',
					'easeOutBack' => 'easeOutBack',
					'easeInOutBack' => 'easeInOutBack',
					'easeInBounce' => 'easeInBounce',
					'easeOutBounce' => 'easeOutBounce',
					'easeInOutBounce' => 'easeInOutBounce',
					'swing' => 'swing',
					'linear' => 'linear'			
				  )
			),
			array(
				'group' => 'Only Perspective',
				'type' => 'textfield',
				'heading' => __( 'Number Of Visible Items', 'js_composer' ),
				'param_name' => 'number_of_visible_items', //numberOfVisibleItems
				'value' => __( "3", "my-text-domain" ),
				'description' => __( "odd number", "js_composer" )  
			),
			array(
				'group' => 'Only Perspective',
				'type' => 'textfield',
				'heading' => __( 'Elements Horizontal Spacing', 'js_composer' ),
				'param_name' => 'elements_horizontal_spacing', //elementsHorizontalSpacing
				'value' => __( "120", "my-text-domain" ),
				'description' => __( "pixels", "js_composer" )  
			),
			array(
				'group' => 'Only Perspective',
				'type' => 'textfield',
				'heading' => __( 'Elements Vertical Spacing', 'js_composer' ),
				'param_name' => 'elements_vertical_spacing', //elementsVerticalSpacing
				'value' => __( "10", "my-text-domain" ),
				'description' => __( "pixels", "js_composer" )  
			),
			
			
			
			
			
			array(
				'group' => 'Carousel & Perspective',
				'type' => 'dropdown',
				'heading' => __( 'Skin Name', 'js_composer' ),
				'param_name' => 'skin',
				'value' => array(
					'black' => 'black',
					'white' => 'white'
				)
			),
			array(
				'group' => 'Carousel & Perspective',
				'type' => 'textfield',
				'heading' => __( 'Auto Play', 'js_composer' ),
				'param_name' => 'auto_play', //autoPlay
				'value' => __( "5", "my-text-domain" ),
				'description' => __( "seconds", "js_composer" )
			),
			array(
				'group' => 'Carousel & Perspective',
				'type' => 'textfield',
				'heading' => __( 'Image Width', 'js_composer' ),
				'param_name' => 'image_width', //imageWidth
				'value' => __( "155", "my-text-domain" )
			),
			array(
				'group' => 'Carousel & Perspective',
				'type' => 'textfield',
				'heading' => __( 'Image Height', 'js_composer' ),
				'param_name' => 'image_height', //imageHeight
				'value' => __( "100", "my-text-domain" )
			),
			array(
				'group' => 'Carousel & Perspective',
				'type' => 'dropdown',
				'heading' => __( 'Enable Touch Screen', 'js_composer' ),
				'param_name' => 'enable_touch_screen', //enableTouchScreen
				'value' => array(
					'Yes' => 'true',
					'No' => 'false'					
				  )
			),
			array(
				'group' => 'Carousel & Perspective',
				'type' => 'dropdown',
				'heading' => __( 'Show All Controllers', 'js_composer' ),
				'param_name' => 'show_all_controllers', //showAllControllers
				'value' => array(
					'Yes' => 'true',
					'No' => 'false'					
				  )
			),
			array(
				'group' => 'Carousel & Perspective',
				'type' => 'dropdown',
				'heading' => __( 'Show Navigation Arrows', 'js_composer' ),
				'param_name' => 'show_nav_arrows', //showNavArrows
				'value' => array(
					'Yes' => 'true',
					'No' => 'false'					
				  )
			),
			array(
				'group' => 'Carousel & Perspective',
				'type' => 'dropdown',
				'heading' => __( 'Show On Init Navigation Arrows', 'js_composer' ),
				'param_name' => 'show_on_init_nav_arrows', //showOnInitNavArrows
				'value' => array(
					'Yes' => 'true',
					'No' => 'false'					
				  )
			),
			array(
				'group' => 'Carousel & Perspective',
				'type' => 'dropdown',
				'heading' => __( 'Auto-Hide Navigation Arrows', 'js_composer' ),
				'param_name' => 'auto_hide_nav_arrows', //autoHideNavArrows
				'value' => array(
					'Yes' => 'true',
					'No' => 'false'					
				  )
			),
			array(
				'group' => 'Carousel & Perspective',
				'type' => 'dropdown',
				'heading' => __( 'Show Bottom Navigation', 'js_composer' ),
				'param_name' => 'show_bottom_nav', //showBottomNav
				'value' => array(
					'Yes' => 'true',
					'No' => 'false'					
				  )
			),
			array(
				'group' => 'Carousel & Perspective',
				'type' => 'textfield',
				'heading' => __( 'Bottom Navigation Margin Bottom', 'js_composer' ),
				'param_name' => 'bottom_nav_margin_bottom', //bottomNavMarginBottom
				'value' => __( "-45", "my-text-domain" ),
				'description' => __( "pixels", "js_composer" )
			)
		),
		'custom_markup' => '
	<div class="wpb_accordion_holder wpb_holder clearfix vc_container_for_children">
	%content%
	</div>
	<div class="tab_controls lbg_add_playlist_item">
		<a class="add_tab vc_add_playlist_item" title="' . __( 'Add Playlist Item', 'js_composer' ) . '"><span class="vc_playlist_item_vc_icon"></span>' . __( 'Add Playlist Item', 'js_composer' ) . '</a>
	</div>
	',
		'default_content' => '
		[logo_showcase_playlist_item title="' . __( 'Playlist Item  1', 'js_composer' ) . '"][/logo_showcase_playlist_item]
	',
		'js_view' => 'VcLogoShowcaseView'
	) );
	
	vc_map( array(
		'name' => __( 'LS Playlist Item', 'js_composer' ),
		'base' => 'logo_showcase_playlist_item',
		'allowed_container_element' => 'vc_row',
		'is_container' => true,
		'content_element' => false,
		'admin_enqueue_js'      => preg_replace( '/\s/', '%20', plugins_url( 'assets/playlist_item.js', __FILE__ ) ),
		// This will load extra js file in backend (when you edit page with VC)
		// use preg replace to be sure that "space" will not break logic

		'admin_enqueue_css'     => preg_replace( '/\s/', '%20', plugins_url( 'assets/playlist_item.css', __FILE__ ) ),
		// This will load extra css file in backend (when you edit page with VC)		
		'params' => array(
			array(
				'type' => 'textfield',
				'heading' => __( 'Image Title', 'js_composer' ),
				'param_name' => 'title'
			),
			array(
				'type' => 'attach_image',
				'heading' => __( 'Image', 'js_composer' ),
				'param_name' => 'img',
				'description' => __( 'Select an image from Media Library', 'js_composer' )
				
			),	
			array(
				'type' => 'textfield',
				'heading' => __( 'Link For The Image', 'js_composer' ),
				'param_name' => 'data_link' //data-link
			),
			array(
				'type' => 'dropdown',
				'heading' => __( 'Link Target', 'js_composer' ),
				'param_name' => 'data_target', //data-target
				'value' => array(
					'_blank' => '_blank',
					'_self' => '_self'
				  )
			)
		),
		'js_view' => 'VcPlaylistItemView'
	) );
	




	if ( class_exists( "WPBakeryShortCode" ) ) {
		$logo_showcase_addon_path = trailingslashit(dirname(__FILE__)); 
		include_once($logo_showcase_addon_path . 'vc_contentadmin/logo_showcase-accordion.php');
		include_once($logo_showcase_addon_path . 'vc_contentadmin/logo_showcase-accordion-tab.php');
		

	} // End Class

}


//add_action('vc_after_init', 'logo_showcase_addon_vc_map_init');
add_action('vc_before_init', 'logo_showcase_addon_vc_map_init');






if (!function_exists('lbg_unstrip_array')) {
	//stripslashes for an entire array
	function lbg_unstrip_array($array){
		if (is_array($array)) {	
			foreach($array as &$val){
				if(is_array($val)){
					$val = unstrip_array($val);
				} else {
					$val = stripslashes($val);
					
				}
			}
		}
		return $array;
	}
}




function logo_showcase_addon_enqueue_scripts_and_styles() {
	//load scripts in front-end
	//if (!is_admin()) {
				wp_enqueue_style('lbg_logoshowcase_site_grid_css', plugins_url('grid/css/logogridshowcase.css', __FILE__));
				wp_enqueue_style('lbg_logoshowcase_site_carousel_css', plugins_url('carousel/css/logo_carousel.css', __FILE__));
				wp_enqueue_style('lbg_logoshowcase_site_perspective_css', plugins_url('perspective/css/logo_perspective.css', __FILE__));	
				
		
				wp_enqueue_script('jquery');

				wp_enqueue_script('jquery-ui-core');
				wp_enqueue_script('jquery-ui-widget');
				wp_enqueue_script('jquery-ui-mouse');
				wp_enqueue_script('jquery-ui-accordion');
				wp_enqueue_script('jquery-ui-autocomplete');
				wp_enqueue_script('jquery-ui-slider');
				wp_enqueue_script('jquery-ui-tabs');
				wp_enqueue_script('jquery-ui-sortable');
				wp_enqueue_script('jquery-ui-draggable');
				wp_enqueue_script('jquery-ui-droppable');
				wp_enqueue_script('jquery-ui-selectable');
				wp_enqueue_script('jquery-ui-position');
				wp_enqueue_script('jquery-ui-datepicker');
				wp_enqueue_script('jquery-ui-resizable');
				wp_enqueue_script('jquery-ui-dialog');
				wp_enqueue_script('jquery-ui-button');				
				wp_enqueue_script('jquery-form');
				wp_enqueue_script('jquery-color');
				wp_enqueue_script('jquery-masonry');
				wp_enqueue_script('jquery-ui-progressbar');
				wp_enqueue_script('jquery-ui-tooltip');				
				wp_enqueue_script('jquery-effects-core');
				wp_enqueue_script('jquery-effects-blind');
				wp_enqueue_script('jquery-effects-bounce');
				wp_enqueue_script('jquery-effects-clip');
				wp_enqueue_script('jquery-effects-drop');
				wp_enqueue_script('jquery-effects-explode');
				wp_enqueue_script('jquery-effects-fade');
				wp_enqueue_script('jquery-effects-fold');
				wp_enqueue_script('jquery-effects-highlight');
				wp_enqueue_script('jquery-effects-pulsate');
				wp_enqueue_script('jquery-effects-scale');
				wp_enqueue_script('jquery-effects-shake');
				wp_enqueue_script('jquery-effects-slide');			
				wp_enqueue_script('jquery-effects-transfer');
				
				
				
				
				wp_register_script('lbg-touch', plugins_url('carousel/js/jquery.ui.touch-punch.min.js', __FILE__));
				wp_enqueue_script('lbg-touch');		
				
				wp_register_script('lbg-logoshowcase_grid', plugins_url('grid/js/logogridshowcase.js', __FILE__));
				wp_enqueue_script('lbg-logoshowcase_grid');		
				
				wp_register_script('lbg-logoshowcase_carousel', plugins_url('carousel/js/logo_carousel.js', __FILE__));
				wp_enqueue_script('lbg-logoshowcase_carousel');
				
				wp_register_script('lbg-logoshowcase_perspective', plugins_url('perspective/js/logo_perspective.js', __FILE__));
				wp_enqueue_script('lbg-logoshowcase_perspective');
	//}
}
add_action( 'wp_enqueue_scripts', 'logo_showcase_addon_enqueue_scripts_and_styles' );




//the shortcodes
add_shortcode( 'logo_showcase_playlist_item', 'logo_showcase_playlist_item_func' );
function logo_showcase_playlist_item_func( $atts, $content = null ) { // New function parameter $content is added!
	global $wpdb;
	
	$the_img=wp_get_attachment_image_src($atts["img"], "large");
	$img_over='';
	if ($the_img[0]!='') {
		if (strpos($the_img[0], 'wp-content',9)===false)
			list($width, $height, $type, $attr) = getimagesize($the_img[0]);
		else
			list($width, $height, $type, $attr) = getimagesize( ABSPATH.substr($the_img[0],strpos($the_img[0], 'wp-content',9)) );
		$img_over='<img src="'.$the_img[0].'" width="'.$width.'" height="'.$height.'" alt="'.$atts['title'].'"  title="'.$atts['title'].'" />';
		
	}


	$aux_content='<li data-link="'.$atts['data_link'].'" data-target="'.$atts['data_target'].'" >'.$img_over.'</li>';	
	

	return str_replace("\r\n", '', $aux_content);	
}


add_shortcode( 'logo_showcase', 'logo_showcase_func' );
	function logo_showcase_func( $atts, $content = null ) { // New function parameter $content is added!
		global $rand_id;
		$initial_vals_arr=array(
			'id' => $rand_id,
			'type' => 'grid',
			'width' => 960,
			'center_plugin' => 'true',
			'responsive' => 'true',
			'responsive_relative_to_browser' => 'false',
			'target' => '_blank',
			'show_tooltip' => 'true',
			'grayscale' => 'false',
			'border' => 0,
			'border_color_off' => 'transparent',
			'border_color_on' => '#FF0000',
			'colum_width' => 100,
			'gutter' => 25,
			'margin_left' => 25,
			'margin_right' => 25,
			'margin_top' => 10,
			'bottom_nav_position' => 'center',
			'number_of_thumbs_per_screen' => 0,
			'animation_time' => 0.8,
			'easing' => 'easeOutQuad',
			'number_of_visible_items' => 3,
			'elements_horizontal_spacing' => 120,
			'elements_vertical_spacing' => 10,
			'skin' => 'black',
			'auto_play' => 5,
			'image_width' => 155,
			'image_height' => 100,
			'enable_touch_screen' => 'true',
			'show_all_controllers' => 'true',
			'show_nav_arrows' => 'true',
			'show_on_init_nav_arrows' => 'true',
			'auto_hide_nav_arrows' => 'true',
			'show_bottom_nav' => 'true',
			'bottom_nav_margin_bottom' => -45
	   );
	
	   extract( shortcode_atts( $initial_vals_arr, $atts ) );
	   foreach ($initial_vals_arr as $key => $value) {
    		//echo "Key: $key; Value: $value<br />\n";
			if (!isset($atts[$key])) {
				$atts[$key]=$value;
			}
		}
	  
	   //$content = wpb_js_remove_wpautop($content, true); // fix unclosed/unwanted paragraph tags in $content*/
	 
	   
	//download
	$pathToDownloadFile_aux= WP_PLUGIN_URL.'/'.str_replace(basename( __FILE__),"",plugin_basename(__FILE__)).'logo_showcase/';
	 
	$playlist_str=''; 
	$playlist_str=do_shortcode( $content );
	
	$the_logo=wp_get_attachment_image_src($atts["logo_image_path"], "large");

	
	$aux_content='';
	$new_div_start='';
	$new_div_end='';
	if ($atts["center_plugin"]=='true') {
		$new_div_start='<div class="logo_showcase_my_center_'.$atts["id"].'">';
		$new_div_end='</div>';
		$aux_content='<style>
		.logo_showcase_my_center_'.$atts["id"].' {
			width:'.$atts["width"].'px;  margin:0px auto;
		}
		@media screen and (max-width:'.($atts["width"]).'px) {
			.logo_showcase_my_center_'.$atts["id"].' {
				width:100%;  margin:0px auto;
			}
		}
	</style>';
		
	}
	

	   
	/*$aux_content.='<p><script>
		jQuery(function() {
			jQuery("#logo_showcase_'.$atts["id"].'").logo_showcase({
				skin:"'.$atts["skin"].'",
				width:'.$atts["width"].',
				height:'.$atts["height"].',
				responsive:'.$atts["responsive"].',
				responsiveRelativeToBrowser:'.$atts["responsive_relative_to_browser"].',
				shuffle:'.$atts["shuffle"].',
				firstVideo:'.$atts["first_video"].',
				initialVolume:'.($atts["initial_volume"]/100).',
				loop:'.$atts["loop"].',
				showSearch:'.$atts["show_search"].',
				showTopTitle:'.$atts["show_top_title"].',
				showTimer:'.$atts["show_timer"].',
				showRewindBut:'.$atts["show_rewind_but"].',
				showPlayBut:'.$atts["show_play_but"].',
				showVolumeBut:'.$atts["show_volume_but"].',
				showFacebookBut:'.$atts["show_facebook_but"].',
				facebookAppID:"'.$atts["facebook_app_id"].'",
				facebookShareTitle:"'.$atts["facebook_share_title"].'",
				facebookShareDescription:"'.$atts["facebook_share_description"].'",
				showTwitterBut:'.$atts["show_twitter_but"].',
				showInfoBut:'.$atts["show_info_but"].',
				showDownloadBut:'.$atts["show_download_but"].',
				showPlaylistBut:'.$atts["show_playlist_but"].',
				showFullscreenBut:'.$atts["show_fullscreen_but"].',
				showShuffleBut:'.$atts["show_shuffle_but"].',
				showNextPrevBut:'.$atts["show_next_prev_but"].',
				borderColor:"'.$atts["border_color"].'",
				playlistWidth:'.$atts["playlist_width"].',
				pathToDownloadFile:"'.$pathToDownloadFile_aux.'",
				absUrl:"'.plugins_url("", __FILE__).'/logo_showcase/",
				suggestedQuality:"'.$atts["suggestedQuality"].'",
				controlsBgFullScreenColor:"'.$atts["controls_bg_full_screen_color"].'",
				playlistScrollerBgColorOFF:"'.$atts["playlist_scroller_bg_color_off"].'",
				playlistScrollerBgColorON:"'.$atts["playlist_scroller_bg_color_on"].'",
				numberOfThumbsPerScreen:'.$atts["number_of_thumbs_per_screen"].',
				logoImagePath:"'.$the_logo[0].'",
				logoLink:"'.$atts["logo_link"].'",
				logoTarget:"'.$atts["logo_target"].'",
				showLogo:'.$atts["show_logo"].',
				autoPlayFirstVideo:'.$atts["auto_play_first_video"].',
				playlistRecordShowImg:'.$atts["playlist_record_show_img"].',
				playlistRecordShowTitle:'.$atts["playlist_record_show_title"].',
				playlistRecordShowDesc:'.$atts["playlist_record_show_desc"].',
				playlistRecordHeight:'.$atts["playlist_record_height"].',
				playlistRecordPadding:'.$atts["playlist_record_padding"].',
				playlistTitleFontSize:'.$atts["playlist_title_font_size"].',
				playlistTitleLineHeight:'.$atts["playlist_title_line_height"].',
				playlistDescFontSize:'.$atts["playlist_desc_font_size"].',
				playlistDescLineHeight:'.$atts["playlist_desc_line_height"].',
				playlistRecordBgOffColor:"'.$atts["playlist_record_bg_off_color"].'",
				playlistRecordTitleOffColor:"'.$atts["playlist_record_title_off_color"].'",
				playlistRecordDescOffColor:"'.$atts["playlist_record_desc_off_color"].'",
				playlistRecordBgOffImgOpacity:'.$atts["playlist_record_bg_off_img_opacity"].',
				playlistRecordBgOnColor:"'.$atts["playlist_record_bg_on_color"].'",
				playlistRecordTitleOnColor:"'.$atts["playlist_record_title_on_color"].'",
				playlistRecordDescOnColor:"'.$atts["playlist_record_desc_on_color"].'",
				playlistRecordBgOnImgOpacity:'.$atts["playlist_record_bg_on_img_opacity"].',
				playlistBgColor:"'.$atts["playlist_bg_color"].'",
				playlistRecordTitleLimit:'.$atts["playlist_record_title_limit"].',
				playlistRecordDescLimit:'.$atts["playlist_record_desc_limit"].',
				showPlaylistOnInit:'.$atts["show_playlist_on_init"].',
				topTitleColor:"'.$atts["top_title_color"].'",
				timerColor:"'.$atts["timer_color"].'",
				bufferEmptyColor:"'.$atts["buffer_empty_color"].'",
				bufferFullColor:"'.$atts["buffer_full_color"].'",
				seekbarColor:"'.$atts["seekbar_color"].'",
				volumeOffColor:"'.$atts["volume_off_color"].'",
				volumeOnColor:"'.$atts["volume_on_color"].'",
				playButColorOff:"'.$atts["play_but_color_off"].'",
				playButColorOn:"'.$atts["play_but_color_on"].'",
				googleTrakingOn:'.$atts["google_traking_on"].',
				googleTrakingCode:"'.$atts["google_traking_code"].'",
				getYouTubeData:'.$atts["get_youtube_data"].',
				pathToAjaxFiles:"'.plugins_url("", __FILE__).'/logo_showcase/",
				origThumbImgW:'.$atts["orig_thumb_img_w"].',
				origThumbImgH:'.$atts["orig_thumb_img_h"].'


			});
		});
	</script>	
    '.$new_div_start.'<div id="logo_showcase_'.$atts["id"].'" style="display:none;">
                <ul class="logo_showcase_list">'.$playlist_str.' </ul>    
    </div><br style="clear:both;">'.$new_div_end;*/
	
	
	$showcase_function='';
	$myxloader='';
	$list_name='';
	$the_parameters='';
	switch ($atts["type"]) {
		case 'grid':
			$showcase_function='logogridshowcase';
			$myxloader='';
			$list_name='logs_list';
			$the_parameters='columWidth:'.$atts["colum_width"].',
				gutter:'.$atts["gutter"].',
				margin_left:'.$atts["margin_left"].',
				margin_right:'.$atts["margin_right"].',
				margin_top:'.$atts["margin_top"].',
				responsive:'.$atts["responsive"].',
				responsiveRelativeToBrowser:'.$atts["responsive_relative_to_browser"].',				
				width100Proc:false,
				height100Proc:false,				
				target:"'.$atts["target"].'",
				grayscale:'.$atts["grayscale"].',
				showTooltip:'.$atts["show_tooltip"].',
				absUrl:"'.plugins_url("", __FILE__).'/grid/",
				border:'.$atts["border"].',
				borderColorOFF:"'.$atts["border_color_off"].'",
				borderColorON:"'.$atts["border_color_on"].'"';
			break;
		case 'carousel':
			$showcase_function='logo_carousel';
			$myxloader='<div class="myloader"></div>';
			$list_name='logo_carousel_list';
			$the_parameters='skin:"'.$atts["skin"].'",
				responsive:'.$atts["responsive"].',
				responsiveRelativeToBrowser:'.$atts["responsive_relative_to_browser"].',				
				width:'.$atts["width"].',
				width100Proc:false,
				height100Proc:false,				
				autoPlay:'.$atts["auto_play"].',
				target:"'.$atts["target"].'",
				grayscale:'.$atts["grayscale"].',
				showTooltip:'.$atts["show_tooltip"].',				
				absUrl:"'.plugins_url("", __FILE__).'/carousel/",
				numberOfThumbsPerScreen:'.$atts["number_of_thumbs_per_screen"].',
				enableTouchScreen:'.$atts["enable_touch_screen"].',
				showAllControllers:'.$atts["show_all_controllers"].',
				showNavArrows:'.$atts["show_nav_arrows"].',
				showOnInitNavArrows:'.$atts["show_on_init_nav_arrows"].',
				autoHideNavArrows:'.$atts["auto_hide_nav_arrows"].',
				showBottomNav:'.$atts["show_bottom_nav"].',
				bottomNavMarginBottom:'.$atts["bottom_nav_margin_bottom"].',
				bottomNavPosition:"'.$atts["bottomNavPosition"].'",	
				imageWidth:'.$atts["image_width"].',
				imageHeight:'.$atts["image_height"].',
				border:'.$atts["border"].',
				borderColorOFF:"'.$atts["border_color_off"].'",
				borderColorON:"'.$atts["border_color_on"].'"';
			break;
		case 'perspective':
			$showcase_function='logo_perspective';
			$myxloader='<div class="myloader"></div>';
			$list_name='logo_perspective_list';
			$the_parameters='skin:"'.$atts["skin"].'",
				responsive:'.$atts["responsive"].',
				responsiveRelativeToBrowser:'.$atts["responsive_relative_to_browser"].',				
				width:'.$atts["width"].',
				width100Proc:false,
				height100Proc:false,				
				autoPlay:'.$atts["auto_play"].',
				target:"'.$atts["target"].'",
				grayscale:'.$atts["grayscale"].',
				showTooltip:'.$atts["show_tooltip"].',				
				absUrl:"'.plugins_url("", __FILE__).'/perspective/",
				numberOfVisibleItems:'.$atts["number_of_visible_items"].',
				elementsHorizontalSpacing:'.$atts["elements_horizontal_spacing"].',
				elementsVerticalSpacing:'.$atts["elements_vertical_spacing"].',
				animationTime:'.$atts["animation_time"].',
				easing:"'.$atts["easing"].'",
				enableTouchScreen:'.$atts["enable_touch_screen"].',
				showAllControllers:'.$atts["show_all_controllers"].',
				showNavArrows:'.$atts["show_nav_arrows"].',
				showOnInitNavArrows:'.$atts["show_on_init_nav_arrows"].',
				autoHideNavArrows:'.$atts["auto_hide_nav_arrows"].',
				showBottomNav:'.$atts["show_bottom_nav"].',
				bottomNavMarginBottom:'.$atts["bottom_nav_margin_bottom"].',				
				imageWidth:'.$atts["image_width"].',
				imageHeight:'.$atts["image_height"].',
				border:'.$atts["border"].',
				borderColorOFF:"'.$atts["border_color_off"].'",
				borderColorON:"'.$atts["border_color_on"].'"';
			break;
	}	
	
	
	
	$aux_content.='<script>
		jQuery(function() {
			jQuery("#logosshowcase_'.$atts["id"].'").'.$showcase_function.'({'.
				$the_parameters.
			'});	
		});
	</script>	
            '.$new_div_start.'<div id="logosshowcase_'.$atts["id"].'">'.$myxloader.'<ul class="'.$list_name.'">'.$playlist_str.'</ul></div>'.$new_div_end;
	
	return str_replace("\r\n", '', $aux_content);	   
	   
	}
	
?>