<?php
add_action( 'plugins_loaded', 'the_seo_framework_init', 5 );
/**
 * Load The_SEO_Framework_Load class
 *
 * @action plugins_loaded
 * @priority 5 Use anything above 5, or any action later than plugins_loaded and
 * you can access the class and functions.
 *
 * @since 2.2.5
 */
function the_seo_framework_init() {
	static $the_seo_framework = null;

	if ( the_seo_framework_active() )
		if ( ! isset( $the_seo_framework ) )
			$the_seo_framework = new The_SEO_Framework_Load();

	return $the_seo_framework;
}

/**
 * Allow this plugin to load through filter
 *
 * Applies hmpl_ad_load filters.
 *
 * @return bool $load allow loading of plugin
 *
 * @since 2.1.0
 *
 * @action plugins_loaded
 */
function hmpl_ad_load() {
	//* Marked for removal @since 2.3.5
	$load = apply_filters( 'hmpl_ad_load', true );

	//* @since 2.3.0 filter.
	return (bool) apply_filters( 'the_seo_framework_load', $load );;
}

define( 'AUTODESCRIPTION_DIR_PATH_CLASS', THE_SEO_FRAMEWORK_DIR_PATH . '/inc/classes/' );
//* @since 2.3.0 constant.
define( 'THE_SEO_FRAMEWORK_DIR_PATH_CLASS', AUTODESCRIPTION_DIR_PATH_CLASS );

define( 'AUTODESCRIPTION_DIR_PATH_FUNCT', THE_SEO_FRAMEWORK_DIR_PATH . '/inc/functions/' );
//* @since 2.3.0 constant.
define( 'THE_SEO_FRAMEWORK_DIR_PATH_FUNCT', AUTODESCRIPTION_DIR_PATH_FUNCT );

/**
 * Load plugin files
 * @uses THE_SEO_FRAMEWORK_DIR_PATH_FUNCT
 * @uses THE_SEO_FRAMEWORK_DIR_PATH_CLASS
 *
 * @since 2.1.6
 */
require_once( THE_SEO_FRAMEWORK_DIR_PATH_FUNCT . 'compat.php' );
require_once( THE_SEO_FRAMEWORK_DIR_PATH_FUNCT . 'optionsapi.php' );

require_once( THE_SEO_FRAMEWORK_DIR_PATH_CLASS . 'init.class.php' );
require_once( THE_SEO_FRAMEWORK_DIR_PATH_CLASS . 'admininit.class.php' );
require_once( THE_SEO_FRAMEWORK_DIR_PATH_CLASS . 'render.class.php' );
require_once( THE_SEO_FRAMEWORK_DIR_PATH_CLASS . 'detect.class.php' );
require_once( THE_SEO_FRAMEWORK_DIR_PATH_CLASS . 'postdata.class.php' );
require_once( THE_SEO_FRAMEWORK_DIR_PATH_CLASS . 'generate.class.php' );
require_once( THE_SEO_FRAMEWORK_DIR_PATH_CLASS . 'search.class.php' );
require_once( THE_SEO_FRAMEWORK_DIR_PATH_CLASS . 'doingitright.class.php' );
require_once( THE_SEO_FRAMEWORK_DIR_PATH_CLASS . 'pageoptions.class.php' );
require_once( THE_SEO_FRAMEWORK_DIR_PATH_CLASS . 'inpost.class.php' );
require_once( THE_SEO_FRAMEWORK_DIR_PATH_CLASS . 'adminpages.class.php' );
require_once( THE_SEO_FRAMEWORK_DIR_PATH_CLASS . 'sanitize.class.php' );
require_once( THE_SEO_FRAMEWORK_DIR_PATH_CLASS . 'siteoptions.class.php' );
require_once( THE_SEO_FRAMEWORK_DIR_PATH_CLASS . 'networkoptions.class.php' );
require_once( THE_SEO_FRAMEWORK_DIR_PATH_CLASS . 'metaboxes.class.php' );
require_once( THE_SEO_FRAMEWORK_DIR_PATH_CLASS . 'sitemaps.class.php' );

/**
 * God class.
 *
 * Extendeding upon parent classes.
 *
 * @since 2.1.6
 */
class The_SEO_Framework_Load extends AutoDescription_Sitemaps {

	/**
	 * Constructor, load parent constructor
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Wrapper for function calling through parameters. The golden nugget.
	 *
	 * @param array|string $callback the method array or function string.
	 * @param string $version the version of AutoDescription the function is used.
	 *
	 * @param array|bool|string $output the method or function to return.
	 *
	 * @since 2.2.2
	 *
	 * @return $output The function called.
	 *
	 * @param array|string $params The arguments passed to the function.
	 * @since 2.2.4
	 */
	public function call_function( $callback, $version = '', $params = array() ) {

		$output = '';

		if ( is_string( $callback ) )
			$function = $callback; // redundnant?

		/**
		 * Convert string/object to array
		 */
		if ( is_object( $callback ) ) {
			$function = array( $callback, '' );
		} else {
			$function = (array) $callback;
		}

		/**
		 * Convert string/object to array
		 */
		if ( is_object( $params ) ) {
			$args = array( $params, '' );
		} else {
			$args = (array) $params;
		}

		/**
		 * Fetch method/function
		 */
		if ( is_object( $function[0] ) ) {
			$method = (string) $function[1];

			if ( $function[0] == $this ) {
				if ( method_exists( $this, $method ) ) {
					if ( empty( $args ) ) {
						// In-Object calling.
						$output = call_user_func( array( $this, $method ) );
					} else {
						// In-Object calling.
						$output = call_user_func_array( array( $this, $method ), (array) $args );
					}
				} else if ( $version ) {
					$version = $this->autodescription_version( $version );
					 _doing_it_wrong( (string) $this . '::' . (string) $method, __( "Class or Method not found.", 'autodescription' ), $version );
				}
			} else {
				// This doesn't work in Apache configurations.
				$class = get_class( $function[0] );
				$method = (string) $function[1];

				if ( method_exists( $class, $method ) ) {
					if ( empty( $args ) ) {
						// Static calling
						$output = call_user_func( $class . '::'. $method );
					} else {
						// Static calling
						$output = call_user_func_array( $class . '::'. $method, (array) $args );
					}
				} else if ( $version ) {
					$version = $this->autodescription_version( $version );
					 _doing_it_wrong( (string) $class . '::' . (string) $method, __( "Class or Method not found. Needs to be called statically.", 'autodescription' ), $version );
				}
			}
		} else if ( is_string( $function[0] ) && ! empty( $function[1] ) ) {
			if ( empty( $args ) ) {
				// Static calling
				$output = call_user_func( $function[0] . '::' . $function[1] );
			} else {
				// Static calling
				$output = call_user_func_array( $function[0] . '::' . $function[1], (array) $args );
			}
		} else if ( is_string( $function[0] ) ) {
			$func = $function[0];
			if ( empty( $args ) ) {
				$output = call_user_func( $func );
			} else {
				$output = call_user_func_array( $func, (array) $args );
			}
		} else if ( $version ) {
			$version = $this->autodescription_version( $version );
			_doing_it_wrong( (string) $callback, __( "Function needs to be called as string.", 'autodescription' ), $version );
		}

		return $output;
	}

	/**
	 * Helper function for Doing it Wrong
	 *
	 * @since 2.3.0
	 */
	public function the_seo_framework_version( $version = '' ) {

		$output = is_null( $version ) ? '' : sprintf( __( '%s of The SEO Framework', 'autodescription' ), $version );

		return $output;
	}

	/**
	 * Helper function for Doing it Wrong
	 *
	 * @since 2.2.4
	 *
	 * @deprecated
	 * @since 2.3.0
	 *
	 * Marked for remval @since 2.3.5
	 */
	public function autodescription_version( $version = '' ) {
		//* Wow, a deprecation that deprecates using itself. :D
		_deprecated_function( __FUNCTION__, $this->the_seo_framework_version( '2.3.0' ), 'The_SEO_Framework_Load::the_seo_framework_version' );

		return $this->the_seo_framework_version( $version );
	}

}

//* Load deprecated functions and classes.
require_once( THE_SEO_FRAMEWORK_DIR_PATH . 'inc/deprecated/deprecated.class.php' );
require_once( THE_SEO_FRAMEWORK_DIR_PATH . 'inc/deprecated/deprecated.php' );

/**
 * FLush permalinks on activation/deactivation
 *
 * Calls functions statically.
 *
 * @since 2.2.9
 */
register_activation_hook( THE_SEO_FRAMEWORK_PLUGIN_BASE_FILE, array( 'The_SEO_Framework_Load', 'flush_rewrite_rules_activation' ) );
register_deactivation_hook( THE_SEO_FRAMEWORK_PLUGIN_BASE_FILE, array( 'The_SEO_Framework_Load', 'flush_rewrite_rules_deactivation' ) );
