<?php
/**
 * Extended charset support
 *
 * @uses strlen
 * @return mb_strlen
 *
 * @since 1.3.0
 */
if ( !function_exists( '_mb_strlen' ) ) {
	function _mb_strlen( $str ) {
		$charset = get_option( 'blog_charset' );
		if ( ! in_array( $charset, array( 'utf8', 'utf-8', 'UTF8', 'UTF-8' ) ) )
			return strlen( $str );

		// Use the regex unicode support to separate the UTF-8 characters into an array
		preg_match_all( '/./us', $str, $match );
		return count( $match[0] );
	}
}

if ( !function_exists( 'mb_strlen' ) ) {
	function mb_strlen( $str ) {
		return _mb_strlen( $str );
	}
}

/**
 * Extended charset support
 *
 * @uses substr
 * @return mb_substr
 *
 * @since 1.3.0
 */
if ( !function_exists( '_mb_substr' ) ) {
	function _mb_substr( $str, $start, $length ) {
		$charset = get_option( 'blog_charset' );
		if ( ! in_array( $charset, array( 'utf8', 'utf-8', 'UTF8', 'UTF-8' ) ) )
			return substr( $str, $start, $length );

		// Use the regex unicode support to separate the UTF-8 characters into an array
		preg_match_all( '/./us', $str, $match );
		return substr( $match[0], $start, $length );
	}
}

if ( !function_exists( 'mb_substr' ) ) {
	function mb_substr( $str, $start, $length = 0 ) {
		return _mb_substr( $str, $start, $length );
	}
}

/**
 * Extended charset support
 *
 * @uses strpos
 * @return mb_strpos
 *
 * @since 1.3.0
 */
if ( !function_exists( '_mb_strpos' ) ) {
	function _mb_strpos( $str, $needle, $offset ) {
		$charset = get_option( 'blog_charset' );
		if ( ! in_array( $charset, array( 'utf8', 'utf-8', 'UTF8', 'UTF-8' ) ) )
			return strpos( $str, $needle, $offset );

		// Use the regex unicode support to separate the UTF-8 characters into an array
		preg_match_all( '/./us', $str, $match );
		return strpos( $match[0], $start, $length );
	}
}

if ( !function_exists( 'mb_strpos' ) ) {
	function mb_strpos( $str, $needle, $offset = 0 ) {
		return _mb_strpos( $str, $needle, $offset );
	}
}
