<?php
/**
 * Class AutoDescription_Search
 *
 * Excludes pages from search based on options
 *
 * @since 2.1.6
 */
class AutoDescription_Search extends AutoDescription_Generate {

	/**
	 * Constructor, load parent constructor
	 *
	 * Initalizes options
	 */
	public function __construct() {
		parent::__construct();

		//* @TODO make this option optional?
		add_filter( 'pre_get_posts', array( $this, 'search_filter' ) );
	}

	/**
	 * Fetches posts with exclude_local_search option on
	 *
	 * @param array $post_ids			The post id's which are excluded
	 * @param array $args				Posts search arguments
	 * @param array $protected_posts	Posts array with excluded key
	 *
	 * @since 2.1.7
	 *
	 * @todo use transients which will be deleted upon post change? Could be heavy.
	 * Transient upon transient, which forces cache of the transient for an hour?
	 */
	public function exclude_search_ids() {

		$post_ids = wp_cache_get( 'exclude_search', 'autodescription' );
		if ( false === $post_ids ) {
			$post_ids = array();

			$args = array(
				'post_type' => 'any',
				'meta_key' => 'exclude_local_search',
				'meta_value' => 1,
				'posts_per_page' => 99999, // get them all! D:
	/*			'meta_compare' => 'LIKE',
				'post_status' => array('publish','private'),*/
			);

			$protected_posts = get_posts( $args );
			if ( $protected_posts ) {
				$post_ids = wp_list_pluck( $protected_posts, 'ID' );
			}

			wp_cache_set( 'exclude_search', $post_ids, 'autodescription', 86400 );
		}

		// return an array of exclude post IDs
		return $post_ids;
	}

	/**
	 * Fetches posts with exclude_local_search option on
	 *
	 * @param array $query				The search query
	 * @param array $protected_posts	Posts array with excluded key
	 *
	 * @uses $this->exclude_search_ids()
	 *
	 * @since 2.1.7
	 *
	 * @todo run this only when one post triggers this option?
	 */
	public function search_filter( $query ) {

		// Don't exclude pages in wp-admin
		if ( ! is_admin() ) {
			if ( $query->is_search ) {

				$protected_posts = $this->exclude_search_ids();
				if ( !empty( $protected_posts ) )
					$query->set('post__not_in', $protected_posts);

				// Parse all ID's, even beyond the first page.
				$query->set( 'no_found_rows', false );
			}
		}
	}

}
