<?php
/**
 * Class AutoDescription_PostData
 *
 * Pulls data from posts/pages
 * Returns strings/arrays
 *
 * @since 2.1.6
 */
class AutoDescription_PostData extends AutoDescription_Detect {

	/**
	 * Standard Words array
	 *
	 * Holds words which have no SEO value to be stripped
	 *
	 * Uses localisation
	 *
	 * @since ???
	 * @todo
	 */
	protected $standardwords = array();

	/**
	 * Constructor, load parent constructor
	 */
	public function __construct() {
		parent::__construct();
	}

	/**
	 * Get the excerpt of the post
	 *
	 * @since 1.0.0
	 *
	 * @param string $excerpt the Excerpt
	 * @param int $the_id The Post ID.
	 */
	public function get_excerpt_by_id( $excerpt = '', $the_id = '' ) {

		/**
		 * Use the 2nd parameter.
		 *
		 * @since 2.2.8
		 */
		if ( !empty( $the_id ) ) {
			$post = get_post( $the_id );
		} else {
			global $post_id;

			$post = get_post( $post_id );
		}

		//* Stop getting something that doesn't exists. E.g. 404
		if ( ! is_object( $post ) )
			return '';

		/**
		 * No need to run esc_attr after wp_strip_all_tags
		 *
		 * @since 2.2.8
		 */
		if ( empty( $excerpt ) ) {
			$excerpt = wp_strip_all_tags( strip_shortcodes( $post->post_content ) );
		} else {
			$excerpt = esc_attr( $excerpt );
		}

		$excerpt = str_replace( array( "\r\n", "\r", "\n" ), "\n", $excerpt );

		$lines = explode( "\n", $excerpt );
		$new_lines = array();

		//* Remove line breaks
		foreach ( $lines as $i => $line ) {
			if ( ! empty( $line ) )
				$new_lines[] = trim( $line ) . ' ';
		}

		$output = implode( $new_lines );

		return $output;
	}

}
