<?php
/**
 * Plugin Name: The SEO Framework
 * Plugin URI: https://wordpress.org/plugins/autodescription/
 * Description: The SEO Framework makes sure your SEO is always up-to-date without any configuration needed. It's based upon the Genesis SEO.
 * Version: 2.3.0
 * Author: Sybre Waaijer
 * Author URI: https://cyberwire.nl/
 * License: GPLv2 or later
 * Text Domain: autodescription
 * Domain Path: /language
 */

/**
 * CDN Cache buster.
 * Not many caching plugins use CDN in dashboard. What a shame.
 *
 * @since 1.0.0
 */
if ( !defined( 'AUTOD_PLUGIN_VER' ) )
	define( 'AUTOD_PLUGIN_VER', '2.3.0' );

//* @since 2.3.0 constant.
define( 'THE_SEO_FRAMEWORK_VERSION', AUTOD_PLUGIN_VER );

/**
 * Plugin options filter
 * We can't change the options name without erasing the settings.
 * We can change the filter, however. So we did.
 *
 * @since 2.2.2
 */
//* Marked for remval @since 2.3.5
if ( !defined( 'AUTODESCRIPTION_SITE_OPTIONS' ) )
	define( 'AUTODESCRIPTION_SITE_OPTIONS', apply_filters( 'autodescription_site_settings', 'autodescription-site-settings' ) );

//* @since 2.3.0 constant.
//* @since 2.3.0 filter.
define( 'THE_SEO_FRAMEWORK_SITE_OPTIONS', (string) apply_filters( 'the_seo_framework_site_options', AUTODESCRIPTION_SITE_OPTIONS ) );

/**
 * Plugin options filter
 * We can't change the options name without erasing the settings.
 * We can change the filter, however. So we did.
 *
 * @since 2.2.2
 */
//* Marked for remval @since 2.3.5
if ( !defined( 'AUTODESCRIPTION_NETWORK_OPTIONS' ) )
	define( 'AUTODESCRIPTION_NETWORK_OPTIONS', apply_filters( 'autodescription_network_settings', 'autodescription-network-settings' ) );

//* @since 2.3.0 constant.
define( 'THE_SEO_FRAMEWORK_NETWORK_OPTIONS', (string) apply_filters( 'the_seo_framework_network_settings', AUTODESCRIPTION_NETWORK_OPTIONS ) );

/**
 * The plugin map url.
 * Used for calling browser files.
 * Do not redefine unless you're absolutely sure what you're doing.
 *
 * @since 1.0.0
 */
//* Marked for remval @since 2.3.5
if ( !defined( 'AUTODESCRIPTION_DIR_URL' ) )
	define( 'AUTODESCRIPTION_DIR_URL', plugin_dir_url( __FILE__ ) );

//* @since 2.3.0 constant.
define( 'THE_SEO_FRAMEWORK_DIR_URL', AUTODESCRIPTION_DIR_URL );

/**
 * The plugin map absolute path.
 * Used for calling php files.
 * Do not redefine unless you're absolutely sure what you're doing.
 *
 * @since 1.0.0
 */
//* Marked for remval @since 2.3.5
if ( !defined( 'AUTODESCRIPTION_DIR_PATH' ) )
	define( 'AUTODESCRIPTION_DIR_PATH', plugin_dir_path( __FILE__ ) );

//* @since 2.3.0 constant.
define( 'THE_SEO_FRAMEWORK_DIR_PATH', AUTODESCRIPTION_DIR_PATH );

/**
 * The plugin file relative to the plugins dir.
 *
 * @since 2.2.8
 */
define( 'THE_SEO_FRAMEWORK_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

/**
 * The plugin file, absolute unix path.
 * @since 2.2.9
 */
//* Marked for remval @since 2.3.5
define( 'AUTODESCRIPTION_PLUGIN_BASE_FILE', __FILE__ );

//* @since 2.3.0 constant.
define( 'THE_SEO_FRAMEWORK_PLUGIN_BASE_FILE', AUTODESCRIPTION_PLUGIN_BASE_FILE );

/**
 * Plugin locale 'autodescription'
 *
 * File located in plugin folder autodescription/language/
 *
 * @since 1.0.0
 *
 * @return void
 */
function the_seo_framework_locale_init() {
	load_plugin_textdomain( 'autodescription', false, basename( dirname( __FILE__ ) ) . '/language/');
}
add_action( 'plugins_loaded', 'the_seo_framework_locale_init', 10 );

/**
 * Load plugin files
 *
 * @since 1.0.0
 *
 * @uses THE_SEO_FRAMEWORK_DIR_PATH
 */
require_once( THE_SEO_FRAMEWORK_DIR_PATH . '/load.class.php' );
