<?php 

global $SCHAT;

// Triggable?
$triggable = ( !empty( $option['triggable'] ) ) ? ' data-triggable="' . $option['triggable'] . '" class="schat-opts-triggable hide-if-js"' : ''; 

// Get last security update
$last_update = get_option( 'schat_security_last_update' );

// Check 
if(  empty( $last_update ) || version_compare( SCHAT_VERSION, $last_update, '>' ) ) {
	$security_status = '<p><button class="button" id="SCHAT_upd_security">' . __( 'Update now', 'schat' ) . '</button></p> <span class="schat-error">' . __( "Security rules couldn't be updated.", 'schat' ) . '</span>';

} else {
	$security_status = '<p style="color:green;">' . __( 'Up-to-date', 'schat' ) . '</p>';
}

?>
<tr<?php echo $triggable; ?>>
	<th scope="row"><label for="schat-opts-field-<?php echo $option['id']; ?>"><?php _e( 'Security', 'schat' ); ?></label></th>
	<td>
		<?php echo $security_status; ?>

		<p>
			<small class="description" style="color:#999;font-style:italic;">CX protects your data by adding security rules in your real time application automatically.</small>
		</p>
	</td>
</tr>