<?php
/**
 * SCREETS © 2016
 *
 * Plugin options
 *
 * COPYRIGHT (c) 2016 Screets. All rights reserved.
 * This  is  commercial  software,  only  users  who have purchased a valid
 * license  and  accept  to the terms of the  License Agreement can install
 * and use this program.
 */


global $wp_roles;

// Get default WP user roles
if ( ! isset( $wp_roles ) ) $wp_roles = new WP_Roles();
	
$role_names = $wp_roles->get_names();

$default_roles = array( 'none' => __( 'N/A', 'schat' ) );
$add_roles = array( 'none' => __( 'N/A', 'schat' ) );

foreach ( $role_names as $v => $name ) {
	
	switch( $v ) {
		case 'schat_op':
			break;

		// Default roles
		case 'administrator':
		case 'editor':
		case 'author':
		case 'contributor':
		case 'subscriber':
			$default_roles[ $v ] = $name;
			break;

		// Additional roles
		default:
			$add_roles[ $v ] = $name;

	}
	
}

// Get operators
$schat_op_data = get_users( 'role=schat_op' );

// echo '<pre>'; print_r( $schat_op_data ); echo '</pre>';

if( !empty( $schat_op_data ) ) {

	$schat_ops = '<table class="schat-table"><thead><tr>'
					. '<th>Avatar</th>'
					. '<th>'. __( 'Operator Name', 'schat' ) . '</th>'
					. '<th>'. __( 'Username', 'schat' ) . '</th>'
					. '<th>'. __( 'Email', 'schat' ) . '</th>'
					. '</tr></thead>'
					. '<tbody class="the-list">';

	foreach( $schat_op_data as $op ) {
		
		// Get operator name
		$op_name = get_user_meta( $op->data->ID, 'schat_op_name', true );

		// Table row
		$schat_ops .= '<tr><td><a href="' . admin_url( 'user-edit.php?user_id=' . $op->data->ID ) . '">' . get_avatar( $op->data->user_email, 32 ) .'</a></td><td><strong><a href="' . admin_url( 'user-edit.php?user_id=' . $op->data->ID ) . '">' . ( !empty( $op_name ) ? $op_name : $op->data->display_name )  . '</a></strong></td><td>' . $op->data->display_name . '</td><td>' . $op->data->user_email . '</td></tr>';
	}

	$schat_ops .= '</tbody></table>';

} else {

	$schat_ops = '<small>' . __( 'No operators found', 'schat' ) . '.</small>';

}

/**
 * Plugin options set
 *
 * DO NOT CHANGE DEFAULT OPTIONS.
 * INSTEAD, USE ADMIN PANEL.
 */
$schat_opts_set = array(
	
	/** 
	 * Welcome Tab
	 */
	/*array( 'name' => __( 'Dashboard', 'schat' ), 'type' => 'opentab' ),
	array( 'type' => 'dashboard' ),
	array( 'type' => 'closetab', 'actions' => false ),*/

	/**
	 * General Options
	 */
	array(
		'name' => __( 'General', 'schat' ),
		'id' => 'general',
		'type' => 'opentab'
	),

	// Header: Display
	array(
		'name' => __( 'Display', 'schat' ),
		'type' => 'title'
	),

	// Display chat box
	array(
		'name' => __( 'Display chat box', 'schat' ),
		'desc' => sprintf( __( "<a href='%s' target='_blank'>wp_footer()</a> function has to be located in your theme", 'schat' ), 'http://codex.wordpress.org/Function_Reference/wp_footer' ) ,
		'options' => array(
			'display_chatbox' => __( 'Display chat box', 'schat' ),
			// 'hide_chatbox_when_offline' => __( 'Hide when all operators offline', 'schat' ),
			'disable_on_mobile' => __( 'Disable on mobile devices', 'schat' ),
			'woocomerce_pages' => __( 'Display in WooCommerce pages', 'schat' ) . ' <small style="color: #999;">(' . __( 'Product pages, cart and checkout', 'schat' ) . ')</small>'
		),
		'std' => array( 
			'display_chatbox' => 'on', 
			// 'hide_chatbox_when_offline' => '', 
			'disable_on_mobile' => '',
			'woocomerce_pages' => ''
		),
		'id' => 'display-chatbox-group',
		'type' => 'checkbox-group'
	),

	// Homepage display options
	array(
		'name' => __( 'Display on homepage?', 'schat' ),
		'desc' => '',
		'options' => array(
			'show' => __( 'Show', 'schat' ),
			'hide' => __( 'Hide', 'schat' )
		),
		'std' => array( 
			'show' => 'on', 
			'hide' => ''
		),
		'id' => 'display-home',
		'type' => 'radio'
	),

	// Display badge
	// array(
	// 	'name' => __( 'Display badge', 'schat' ),
	// 	'desc' => '' ,
	// 	'options' => array(
	// 		'show_badge' => __( 'Show badge on startup automatically', 'schat' )
	// 	),
	// 	'std' => array( 
	// 		'show_badge' => ''
	// 	),
	// 	'id' => 'display-badge-group',
	// 	'type' => 'checkbox-group'
	// ),


	// Auto initiate chat
	/*array(
		'name' => __( 'Auto-initiate chat after', 'schat' ),
		'desc' => __( '0 (zero) for disabling auto-initiate', 'schat' ),
		'std' => 0,
		'min' => 0,
		'max' => 600,
		'units' => __( 'second(s)', 'schat' ),
		'id' => 'autoinitiate_sec',
		'type' => 'number'
	),
*/	

	// Header: Notifications
	array(
		'name' => __( 'Notifications', 'schat' ),
		'type' => 'title'
	),

	// Notify operators
	array(
		'name' => __( 'Notify operators by email', 'schat' ),
		'desc' => '',
		'options' => array(
			'new-user' => __( 'When visitor logs into chat', 'schat' )
		),
		'std' => array( 
			'new-user' => '' 
		),
		'id' => 'ntf-email-group',
		'type' => 'checkbox-group'
	),


	// Header: License
	array(
		'name' => __( 'License', 'schat' ),
		'type' => 'title'
	),

	// Screets API
	array(
		'name' => '<div class="schat-license-img"></div>' . __( 'Screets API Key', 'schat' ),
		'desc' => __( 'It is required to activate the plugin and get <strong>free updates</strong>.', 'schat' ) . '<br><small>* ' . __( 'Note that you might need to re-login WordPress after updating your API key.', 'schat' ) . '</small>',
		'std' => '',
		'id' => 'license_key',
		'type' => 'license'
	),

	array( 'type' => 'closetab' ),


	/**
	 * Appearance
	 */
	array(
		'name' => __( 'Appearance', 'schat' ),
		'id' => 'appearance',
		'type' => 'opentab'
	),

	// Header
	array(
		'name' => __( 'Chat Window', 'schat' ),
		'type' => 'title'
	),

	// Skin
	array(
		'name' => __( 'Skin', 'schat' ),
		'desc' => '',
		'options' => array(
			'basic' => '<img src="' . SCHAT_URL . '/assets/img/schat-skin-basic.png" style="vertical-align:text-top"> &nbsp; ',
			'fixed' => '<img src="' . SCHAT_URL . '/assets/img/schat-skin-fixed.png"  style="vertical-align:text-top">'
		),
		'std' => 'basic',
		'id' => 'base_skin',
		'type' => 'radio'
	),

	// Primary Color
	array(
		'name' => __( 'Primary Color', 'schat' ),
		'desc' => __( 'Also using for colorizing offline emails', 'schat' ),
		'std' => '#e54440',
		'id' => 'primary_color',
		'type' => 'color'
	),

	// Link Color
	array(
		'name' => __( 'Link Color', 'schat' ),
		'desc' => '',
		'std' => '#3894db',
		'id' => 'link_color',
		'type' => 'color'
	),

	// Widget size
	array(
		'name' => __( 'Widget size', 'schat' ),
		'desc' => '',
		'std' => 245,
		'min' => 170,
		'max' => 400,
		'units' => 'px',
		'id' => 'widget_width',
		'type' => 'number'
	),

	// Widget Position
	array(
		'name' => __( 'Widget Position', 'schat' ),
		'desc' => __( 'Which side do you want to display chat box', 'schat' ),
		'options' => array(
			'top-left' => __( 'top-left', 'schat' ) . '<br>',
			'top-right' => __( 'top-right', 'schat' ) . '<br>',
			'bottom-left' => __( 'bottom-left', 'schat' ) . '<br>',
			'bottom-right' => __( 'bottom-right', 'schat' ),
		),
		'std' => 'bottom-right',
		'id' => 'widget_position',
		'type' => 'radio'
	),

	// Animation
	array(
		'name' => __( 'Animation', 'schat' ),
		'desc' => '',
		'options' => array(
			'' => __( 'N/A', 'schat' ),
			'bounceIn' => 'Bounce In',
			'fadeIn' => 'Fade In'
		),
		'std' => 'bounceInUp',
		'id' => 'anim',
		'btn' => __( 'Animate', 'schat'),
		'type' => 'select'
	),

	// Make anim faster
	array(
		'name' => '',
		'desc' => '' ,
		'options' => array(
			'hinge' => __( 'Speed up animation', 'schat' )
		),
		'std' => array( 
			'hinge' => ''
		),
		'id' => 'anim-group',
		'type' => 'checkbox-group'
	),

	// Offset
	array(
		'name' => __( 'Offset', 'schat' ),
		'desc' => '',
		'std' => array( 30, 'px' ),
		'min' => 0,
		'max' => 720,
		'units' => array( 'px', '%' ),
		'id' => 'tab_offset',
		'type' => 'size'
	),

	// Delay
	array(
		'name' => __( 'Delay', 'schat' ),
		'desc' => __( '1000 ms = 1 second', 'schat' ),
		'std' => 0,
		'min' => 0,
		'max' => 10000000,
		'units' => __( 'milliseconds', 'schat' ),
		'id' => 'delay',
		'type' => 'number'
	),

	// Radius
	array(
		'name' => __( 'Radius', 'schat' ),
		'desc' => '',
		'std' => array( 5, 'px' ),
		'min' => 0,
		'max' => 50,
		'units' => array( 'px', 'em' ),
		'id' => 'radius',
		'type' => 'size'
	),

	// Reply Box Position
	array(
		'name' => __( 'Reply Box Position', 'schat' ),
		'desc' => '',
		'options' => array(
			'top' => __( 'Top', 'schat' ) . ' &nbsp; ',
			'bottom' => __( 'Bottom', 'schat' )
		),
		'std' => 'top',
		'id' => 'reply_pos',
		'type' => 'radio'
	),

	// Operator's default avatar
	array(
		'name' => __( "Company Avatar", 'schat' ),
		'desc' => __( "Default operators' avatar", 'schat' ),
		'type' => 'upload',
		'id' => 'default_avatar',
		'avatar' => SCHAT_URL . '/assets/img/default-avatar.png'
	),
	
	// Avatar Size
	array(
		'name' => __( 'Avatar Size', 'schat' ),
		'desc' => '',
		'std' => 30,
		'min' => 20,
		'max' => 500,
		'units' => 'px',
		'id' => 'avatar_size',
		'type' => 'number'
	),

	
	// Avatar Radius
	array(
		'name' => __( 'Avatar Radius', 'schat' ),
		'desc' => __( 'If avatar size and radius values are the same, avatar will be circle', 'schat' ),
		'std' => 30,
		'min' => 0,
		'max' => 100,
		'units' => 'px',
		'id' => 'avatar_radius',
		'type' => 'number'
	),

	// Header: Chat Button Appearance
	array(
		'name' => __( 'Chat Button', 'schat' ),
		'type' => 'title'
	),

	// Appearance
	array(
		'name' => __( 'Appearance', 'schat' ),
		'desc' => '' ,
		'options' => array(
			'show_title' => __( 'Show title', 'schat' ),
			'show_icon' => __( 'Show icon', 'schat' ),
			'show_arrow' => __( 'Show arrow', 'schat' )
		),
		'std' => array( 
			'show_title' => 'on',
			'show_icon' => '',
			'show_arrow' => 'on'
		),
		'id' => 'chat-btn-group',
		'type' => 'checkbox-group'
	),

	// Button Size
	array(
		'name' => __( 'Button Size', 'schat' ),
		'desc' => __( '0 (zero): No fixed size', 'schat' ),
		'std' => 0,
		'min' => 0,
		'max' => 800,
		'units' => 'px',
		'id' => 'btn_width',
		'type' => 'number'
	),

	// Button title
	array(
		'name' => __( 'Button title', 'schat' ),
		'desc' => '',
		'std' => __( 'Chat with us', 'schat' ),
		'id' => 'when_online',
		'translate' => true,
		'type' => 'text'
	),


	// Header: Messages
	array(
		'name' => __( 'Messages', 'schat' ),
		'type' => 'title'
	),

	// Offline title
	array(
		'name' => __( 'Offline form title', 'schat' ),
		'desc' => '',
		'std' => __( 'Contact us', 'schat' ),
		'id' => 'when_offline',
		'translate' => true,
		'type' => 'text'
	),

	// Reply message placeholder
	array(
		'name' => __( 'Reply field label', 'schat' ),
		'desc' => '',
		'std' => __( 'Type here and hit enter to chat', 'schat' ),
		'id' => 'popup_reply_ph',
		'translate' => true,
		'type' => 'text'
	),

	// Offline body
	array(
		'name' => __( 'Offline body', 'schat' ),
		'desc' => __( 'HTML tags are allowed', 'schat' ),
		'std' => __( "Sorry! We aren't around right now. Leave a message and we'll get back to you, asap.", 'schat' ),
		'id' => 'offline_body',
		'html' => true,
		'type' => 'textarea',
		'translate' => true,
		'rows' => 2
	),

	// Name field label
	array(
		'name' => __( 'Name field label', 'schat' ),
		'desc' => '',
		'std' => __( 'Your name', 'schat' ),
		'id' => 'f_name_label',
		'translate' => true,
		'type' => 'text'
	),

	// Email field label
	array(
		'name' => __( 'Email field label', 'schat' ),
		'desc' => '',
		'std' => __( 'E-mail', 'schat' ),
		'id' => 'f_email_label',
		'translate' => true,
		'type' => 'text'
	),

	// Phone field label
	array(
		'name' => __( 'Phone field label', 'schat' ),
		'desc' => '',
		'std' => __( 'Phone', 'schat' ),
		'id' => 'f_phone_label',
		'translate' => true,
		'type' => 'text'
	),

	// Message field label
	array(
		'name' => __( 'Message field label', 'schat' ),
		'desc' => '',
		'std' => __( 'How can we help you?', 'schat' ),
		'id' => 'f_msg_label',
		'translate' => true,
		'type' => 'text'
	),

	// Send button
	array(
		'name' => __( 'Send button', 'schat' ),
		'desc' => '',
		'std' => __( 'Send', 'schat' ),
		'id' => 'f_send_btn',
		'translate' => true,
		'type' => 'text'
	),

	// Theme Preview
	array(
		'type' => 'preview',
		'reply_ph' => __( 'Type here and hit enter to chat', 'schat' )
	),

	array( 'type' => 'closetab' ),

	/**
	 * Forms
	 */

	array(
		'name' => __( 'Forms', 'schat' ),
		'id' => 'forms',
		'type' => 'opentab'
	),

	

	// Header: Login form
	array(
		'name' => __( 'Login form', 'schat' ),
		'type' => 'title'
	),

	// Display login form
	/*array(
		'name' => __( 'Display login form', 'schat' ),
		'desc' => __( 'If you hide display form, conversation box will appear automatically', 'schat' ),
		'std' => 'on',
		'id' => 'display_login',
		'label'	=>  '',
		'type' => 'checkbox'
	),
*/
	// Prechat welcome message
	array(
		'name' => __( 'Prechat message', 'schat' ),
		'desc' => '',
		'std' => __( "Questions? We're here. Send us a message!", 'schat' ),
		'id' => 'prechat_msg',
		'html' => true,
		'type' => 'textarea',
		'translate' => true,
		'rows' => 2
	),

	// Welcome message
	array(
		'name' => __( 'Welcome message', 'schat' ),
		'desc' => '',
		'std' => __( "Questions, issues or concerns? I'd love to help you!", 'schat' ),
		'id' => 'welc_msg',
		'html' => true,
		'type' => 'textarea',
		'translate' => true,
		'rows' => 2
	),

	// Prechat message when operator ends visitor chat
	/*array(
		'name' => __( 'Prechat message when operator ends visitor chat', 'schat' ),
		'desc' => __( 'HTML tags are allowed', 'schat' ),
		'std' => __( 'Your chat session has been ended. If you have further questions or concerns, please feel free to login chat.', 'schat' ),
		'id' => 'prechat_msg_ended_chat',
		'html' => true,
		'type' => 'textarea',
		'translate' => true,
		'rows' => 2
	),*/

	// Name field (login form)
	array(
		'name' => __( 'Name field', 'schat' ),
		'desc' => '',
		'options' => array(
			'hidden' => __( 'Hidden', 'schat' ),
			'optional' => __( 'Optional', 'schat' ),
			'req' => __( 'Required', 'schat' ),
		),
		'std' => 'optional',
		'id' => 'fl_name',
		'type' => 'select'
	),

	// Email field (login form)
	array(
		'name' => __( 'Email field', 'schat' ),
		'desc' => '',
		'options' => array(
			'hidden' => __( 'Hidden', 'schat' ),
			'optional' => __( 'Optional', 'schat' ),
			'req' => __( 'Required', 'schat' ),
		),
		'std' => 'req',
		'id' => 'fl_email',
		'type' => 'select'
	),

	// Header: Contact form
	array(
		'name' => __( 'Contact form', 'schat' ),
		'type' => 'title'
	),

	// Name field (contact form)
	array(
		'name' => __( 'Name field', 'schat' ),
		'desc' => '',
		'options' => array(
			'hidden' => __( 'Hidden', 'schat' ),
			'optional' => __( 'Optional', 'schat' ),
			'req' => __( 'Required', 'schat' ),
		),
		'std' => 'req',
		'id' => 'f_name',
		'type' => 'select'
	),

	// Email field (contact form)
	array(
		'name' => __( 'Email field', 'schat' ),
		'desc' => '',
		'options' => array(
			'hidden' => __( 'Hidden', 'schat' ),
			'optional' => __( 'Optional', 'schat' ),
			'req' => __( 'Required', 'schat' ),
		),
		'std' => 'req',
		'id' => 'f_email',
		'type' => 'select'
	),

	// Phone field (contact form)
	array(
		'name' => __( 'Phone field', 'schat' ),
		'desc' => '',
		'options' => array(
			'hidden' => __( 'Hidden', 'schat' ),
			'optional' => __( 'Optional', 'schat' ),
			'req' => __( 'Required', 'schat' ),
		),
		'std' => 'hidden',
		'id' => 'f_phone',
		'type' => 'select'
	),


	array( 'type' => 'closetab' ),


	/**
	 * Offline
	 */

	array(
		'name' => __( 'Offline', 'schat' ),
		'id' => 'offline',
		'type' => 'opentab'
	),

	// Header: Offline messages
	array(
		'name' => __( 'Offline messages', 'schat' ),
		'type' => 'title'
	),

	// Email
	array(
		'name' => __( 'Where should offline messages go?', 'schat' ),
		'desc' => '<small>' . __( 'If you need SMTP configuration, you will want to use WP SMTP plugin', 'schat' ) . '.<br/>' . __( "Separate email addresses with comma ','", 'schat' ) . '</small>',
		'placeholder' => __( "Separate email addresses with comma ','", 'schat' ),
		'std' => '',
		'id' => 'admin_emails',
		'type' => 'text'
	),

	// Redirect contact button to that URL
	array(
		'name' => __( 'Redirect offline button to an URL', 'schat' ),
		'desc' => __( 'If you have already contact system, you can link button to an existing page when chat is offline', 'schat' ),
		'placeholder' => 'https://',
		'id' => 'offline_redirect_url',
		'type' => 'text'
	),


	// Site Name
	array(
		'name' => __( 'Site Name', 'schat' ),
		'desc' => '',
		'placeholder' => __( 'Site Name', 'schat' ),
		'id' => 'site_name',
		'type' => 'text'
	),

	// Site URL
	array(
		'name' => __( 'Site URL', 'schat' ),
		'desc' => '',
		'placeholder' => 'http://www.yourdomain.com',
		'id' => 'site_url',
		'type' => 'text'
	),

	// E-mail header
	array(
		'name' => __( 'E-mail header', 'schat' ),
		'desc' => __( 'HTML tags are allowed', 'schat' ),
		'std' => __( "We received your message and will respond within one business day, likely much sooner. We will be happy to provide you with a detailed answer as quickly as we can.", 'schat' ),
		'id' => 'contact_header',
		'html' => true,
		'type' => 'textarea',
		'translate' => true,
		'rows' => 5
	),

	// E-mail footer
	array(
		'name' => __( 'E-mail footer', 'schat' ),
		'desc' => __( 'HTML tags are allowed', 'schat' ),
		'std' => __( "Regards,\n\nYour Company\n<a href='http://www.yourdomain.com'>www.yourdomain.com</a>", 'schat' ),
		'id' => 'contact_footer',
		'html' => true,
		'type' => 'textarea',
		'translate' => true,
		'rows' => 5
	),

	// Send email to visitor as well
	array(
		'name' => __( 'Send a copy to visitor as well', 'schat' ),
		'desc' => '',
		'std' => '',
		'id' => 'contact_email_to_visitor',
		'label'	=>  '',
		'type' => 'checkbox'
	),
	
	array( 'type' => 'closetab' ),

	/**
	 * Users
	 */
	array(
		'name' => __( 'Users', 'schat' ),
		'id' => 'users',
		'type' => 'opentab'
	),

	// Header: Operators and Visitors
	array(
		'name' =>  __( 'Operators & Visitors', 'schat' ),
		'type' => 'title'
	),

	// Operators default role
	array(
		'name' => __( 'Default role of operators', 'schat' ),
		'desc' => __( "Operators have the same capability with this role. It does NOT mean this role will act like operator" , 'schat' ),
		'options' => $default_roles,
		'std' => 'editor',
		'id' => 'op_role',
		'type' => 'select'
	),

	// Operators additional role
	array(
		'name' => __( 'Additional role of operators', 'schat' ),
		'desc' => __( "Additional role from your active WP plugins" , 'schat' ),
		'options' => $add_roles,
		'std' => 'editor',
		'id' => 'op_add_role',
		'type' => 'select'
	),

	// Allowed visitors
	/*array(
		'name' => __( 'Allowed online visitors at a time', 'schat' ),
		'desc' => __( '0 (zero) for unlimited chats', 'schat' ). '<br>' . __( 'Other visitors are allowed to fill out the contact form instead of connecting to chat', 'schat' ),
		'std' => 5,
		'min' => 0,
		'max' => 100,
		'units' => __( 'visitor(s)', 'schat' ),
		'id' => 'allowed_online_visitors',
		'type' => 'number'
	),*/


	// Guest Prefix
	array(
		'name' => __( 'Guest Prefix', 'schat' ),
		'desc' => __( 'For instance, you can write <em>Guest-</em>. Then guest name looks like <em>Guest-1234</em>', 'schat' ),
		'placeholder' => __( 'Guest Prefix', 'schat' ),
		'suffix' => ' + ID',
		'id' => 'guest_prefix',
		'std' => __( 'Guest', 'schat' ) . '-',
		'type' => 'text2'
	),

	// Header: Operators List
	array(
		'name' =>  __( 'Operators List', 'schat' ),
		'type' => 'title'
	),

	// Operators list
	array(
		'html' => '<p><a href="' . admin_url( 'user-new.php' ) . '" class="button">' . __( 'Create Operator', 'schat' ) . '</a> &nbsp; ' . __( "Note that administrators can also answer visitors like operators", 'schat' ) .'.</p><br>' . $schat_ops,
		'type' => 'html'
	),

	array( 'type' => 'closetab' ),
	

	/**
	 * Advanced
	 */

	array(
		'name' => __( 'Advanced', 'schat' ),
		'id' => 'advanced',
		'type' => 'opentab'
	),

	// Header: Firebase Application
	array(
		'name' =>  __( 'Realtime App Platform', 'schat' ),
		'type' => 'title'
	),

	// 
	array(
		'html' =>'<img src="' . SCHAT_URL . '/assets/img/firebase-logo.png" style="display: inline-block;"> ',
		'type' => 'html'
	),


	// Application ID
	array(
		'name' => __( 'App URL', 'schat' ),
		'desc' => __( 'URL of the application', 'schat' ) . '. ' . sprintf( __( '<a href="%s" target="_blank">Create free %s account</a>', 'schat' ),  'https://www.firebase.com/signup/', 'Firebase' ),
		'placeholder' => __( 'App URL', 'schat' ),
		'prefix' => 'https://',
		'suffix' => '.firebaseIO.com',
		'id' => 'app_url',
		'type' => 'text2'
	),


	// Application Token
	array(
		'name' => __( 'App Token', 'schat' ),
		'desc' => __( 'The token can be found under "Secrets" menu in your Firebase dashboard', 'schat' ),
		'placeholder' => __( 'App Token', 'schat' ),
		'id' => 'app_token',
		'type' => 'text'
	),
	
	// Header: Performance
	array(
		'name' => __( 'Performance', 'schat' ),
		'type' => 'title'
	),

	// Realtime data
	array(
		'type' => 'check_data'
	),

	// Check sessions
	array(
		'type' => 'check_session'
	),

	// Compress
	array(
		'name' => __( 'Compress', 'schat' ),
		'desc' => __( 'Improve performance by using compressed CSS / JS files of current template.', 'schat' ),
		'options' => array(
			'compress_js' => __( 'Use compiled JavaScript file', 'schat' ),
			'compress_css' => __( 'Use compressed CSS file', 'schat' ),
			'disable_css' => __( 'Disable CSS file', 'schat' )
		),
		'std' => array( 'compress_js' => 'on', 'compress_css' => 'on', 'disable_css' => '' ),
		'id' => 'compress-group',
		'type' => 'checkbox-group'
	),

	// Faster AJAX
	array(
		'name' => __( 'Faster AJAX', 'schat' ),
		'desc' => __( "This method isn't supported by some PHP/Apache server installations.<br>If contact form sends email after activating this method, you can use it safely.", 'schat' ),
		'label' => __( 'Use faster AJAX for the plugin instead of default WordPress AJAX', 'schat' ),
		'std' => '',
		'id' => 'faster_ajax',
		'type' => 'checkbox'
	),

	// Header: Advanced
	array(
		'name' => __( 'Advanced', 'schat' ),
		'type' => 'title'
	),


	// Debug
	array(
		'name' => __( 'Debug', 'schat' ),
		'desc' => '',
		'label' => __( 'Activate browser console debug', 'schat' ),
		'std' => '',
		'id' => 'debug',
		'type' => 'checkbox'
	),

	// Custom CSS
	array(
		'name' => __( 'Custom CSS', 'schat' ),
		'desc' => '',
		'std' => '',
		'rows' => 5,
		'id' => 'custom_css',
		'type' => 'code'
	),

	// Database tables
	array(
		'type' => 'check_db'
	),

	// Security status
	array(
		'type' => 'check_security'
	),

	// Cross Domain
	/*array(
		'name' => __( 'Cross Domain', 'schat' ),
		'desc' => __( 'If your site homepage is different from WP installation directory or running on a <strong>sub-domain</strong>, you need to cross domain boundaries', 'schat' ),
		'label' => __( 'Bypass cross domain limitations', 'schat' ),
		'std' => '',
		'id' => 'cross_domain',
		'type' => 'checkbox'
	),*/

	// Proxy IPs
	array(
		'name' => __( 'Reverse Proxy IPs', 'schat' ),
		'desc' => __( "If your server is behind a reverse proxy, you must whitelist the proxy IP addresses from which WordPress should trust the HTTP_X_FORWARDED_FOR header in order to properly identify the visitor's IP address. Comma-delimited, e.g. '10.0.1.200,10.0.1.201'", 'schat' ),
		'std' => '',
		'id' => 'proxy_ips',
		'type' => 'text'
	),

	array( 'type' => 'closetab' ),

	/**
	 * Help
	 */

	array(
		'name' => __( 'Help', 'schat' ),
		'id' => 'help',
		'type' => 'opentab'
	),

	array(
		'type' => 'help'
	),

	array( 'type' => 'closetab' )

); 