<?php
/**
 * SCREETS © 2016
 *
 * Administration functions
 *
 * COPYRIGHT (c) 2016 Screets. All rights reserved.
 * This  is  commercial  software,  only  users  who have purchased a valid
 * license  and  accept  to the terms of the  License Agreement can install
 * and use this program.
 */

global $wp_version;

add_action( 'admin_menu', 'schat_admin_menu', 9 );
add_action( 'admin_head', 'schat_admin_head' );
add_filter( 'manage_schat_visitor_posts_columns', 'schat_visitors_custom_cols', 10 );  
add_action( 'manage_schat_visitor_posts_custom_column', 'schat_visitors_cols_content', 10, 2 );
add_filter( 'manage_schat_offline_msg_posts_columns', 'schat_offline_msg_custom_cols', 10 );  
add_action( 'manage_schat_offline_msg_posts_custom_column', 'schat_offline_msg_cols_content', 10, 2 );
add_action( 'add_meta_boxes', 'schat_add_meta_boxes' );
add_action( 'save_post', 'schat_save_post', 0 );
add_filter( 'post_row_actions','schat_row_actions', 10, 2 );

// Show new style admin icon
if( ( version_compare( $wp_version, '3.8', '>=' ) ) )
	add_action( 'admin_head', 'schat_admin_menu_ico' );

/**
 * Setup the Admin menu in WordPress
 *
 * @return void
 */
function schat_admin_menu() {
	global $wp_version, $SCHAT;

	/**
	 * Menu for Admins
	 */
	if( current_user_can( 'manage_options' ) ) {
		add_menu_page(
			$SCHAT->meta['Name'], 
			SCHAT_NAME_SHORT, 
			'manage_options', 
			'screets_lc', 
			'schat_console_template', 
			'dashicons-format-chat',
			'50.9874'
		);
		

	/**
	 * Menu for Operators
	 */
	} else if( current_user_can( 'answer_visitors' ) ) {
		add_menu_page(
			$SCHAT->meta['Name'], 
			SCHAT_NAME_SHORT,
			'schat_op',
			'screets_lc', 
			'schat_console_template', 
			'dashicons-format-chat',
			'50.9874'
		);
	}

	/**
	 * Add submenus
	 */

	// Chat Logs
	add_submenu_page(
		'screets_lc',
		__( 'Chat Logs', 'schat' ), 
		__( 'Chat Logs', 'schat' ), 
		'manage_options',
		'schat_chat_logs', // Menu slug
		'schat_render_chat_logs'

	);

	// Offline Messages
	add_submenu_page(
		'screets_lc',
		__( 'Offline messages', 'schat' ), 
		__( 'Offline messages', 'schat' ), 
		'manage_options',
		'edit.php?post_type=schat_offline_msg'
	);

	/*add_submenu_page(
		'screets_lc',
		__( 'Predefined messages', 'schat' ), 
		__( 'Predefined messages', 'schat' ), 
		'manage_options',
		'edit.php?post_type=schat_predefined_msg'
	);*/

	// Remove publish box some post types
	remove_meta_box( 'submitdiv', 'schat_offline_msg', 'side' );

}

/**
 * Admin header
 *
 * @return void
*/
function schat_admin_head() { ?>
	<style type="text/css">
		
		<?php 

		$post_type = ( !empty( $_GET['post_type'] ) ) ? $_GET['post_type'] : get_post_type();

		// Edit some custom post types
		switch( $post_type ) {
			case 'schat_visitor':
			case 'schat_offline_msg': ?>
			
			.subsubsub .publish,
			.add-new-h2 { display: none; }
		
		<?php
			break;
		}

		?>
	</style>
<?php }

/**
 * Add custom icon
 *
 * @return void
*/
function schat_admin_menu_ico() { ?>
	<style>
	#adminmenu .toplevel_page_chat_x div.wp-menu-image:before {
	  content: "\f130";
	}
	</style>
<?php }

/**
 * Create / Update operator role
 *
 * @return void
*/
function schat_update_op_role( $role, $additional = false ) {
	
	if( !$additional ) {

		// First clean rol
		remove_role( 'schat_op' );

		// Create operator role
		$op_role = add_role( 'schat_op', __( 'LiveChat Operator', 'schat' ) );

		// Add common operator capability
		$op_role->add_cap( 'answer_visitors' );
		
	} else
		$op_role = get_role( 'schat_op' );
	
	switch( $role ) {

		/**
		 * N/A
		 */
		case 'none':
			
			$op_role->add_cap( 'read' );

			break;
		
		/**
		 * Other roles
		 */
		default:

			// Get editor role
			$r = get_role( $role );

			// Add editor caps to chat operator
			foreach( $r->capabilities as $custom_role => $v ) {
				$op_role->add_cap( $custom_role );
			}

			
	}
}


/**
 * Render Chat Console Template
 *
 * @access public
 * @return void
*/
function schat_console_template() {
	
	require SCHAT_PATH . '/core/admin/chat_console.php';
	
}


/**
 * Add custom columns to visitors list
 *
 * @access public
 * @return array
 */
function schat_visitors_custom_cols( $defaults ) {

	// Remove columns
	unset( $defaults['title'] );
	unset( $defaults['date'] );

	// Add columns
	$defaults['_title'] = __( 'Title', 'schat' );
	$defaults['email'] = __( 'Email', 'schat' );
	$defaults['phone'] = __( 'Phone', 'schat' );
	$defaults['details'] = __( 'Details', 'schat' );
	$defaults['last_login'] = __( 'Last Login', 'schat' );


	return $defaults;

}

/**
 * Custom columns content of visitors
 *
 * @access public
 * @return void
 */
function schat_visitors_cols_content( $col, $post_ID ) {

	switch ( $col ) {

		case '_title':

			echo '<strong><a class="row-title" href="' . get_permalink() . '">' . get_the_title() . '</a></strong>';

			echo "<div class='row-actions'><span class='trash'><a class='submitdelete' title='" . esc_attr( __( 'Delete this item permanently' ) ) . "' href='" . get_delete_post_link( $post_ID, '', true ) . "'>" . __( 'Delete Permanently', 'schat' ) . "</a></span></div>";

			break;

		case 'email':
			$email = get_post_meta( $post_ID, 'Email', 1 );
			echo '<a href="mailto:' . $email . '">' . $email . '</a>';
			break;


		case 'phone':
			echo get_post_meta( $post_ID, 'Phone', 1 );
			break;

			
		case 'details':
			echo get_post_meta( $post_ID, 'OS', 1 ) . ', ';
			echo get_post_meta( $post_ID, 'Browser', 1 ) . '<br>';

			echo '<strong>IP:</strong> ' . get_post_meta( $post_ID, 'IP Address', 1 );
			break;
		
		case 'last_login':
			echo get_the_modified_date() . ' ' . get_the_modified_time();
			break;
	} 

}

/**
 * Add custom columns to offline messages list
 *
 * @access public
 * @return array
 */
function schat_offline_msg_custom_cols( $defaults ) {

	unset( $defaults['date'] );

	// Add columns
	$defaults['sender'] = __( 'Sender', 'schat' );
	$defaults['receiver'] = __( 'Receiver', 'schat' );
	$defaults['_date'] = __( 'Date', 'schat' );

	return $defaults;
}


/**
 * Custom columns content of offline messages
 *
 * @access public
 * @return void
 */
function schat_offline_msg_cols_content( $col, $post_ID ) {

	switch ( $col ) {
		case '_date':
			echo human_time_diff( get_the_time( 'U' ) , current_time( 'timestamp' ) );
			break;

		case 'sender':
			echo get_post_meta( $post_ID, 'email', 1 );
			break;

		case 'receiver':
			echo get_post_meta( $post_ID, 'to', 1 );
			break;

	} 

}

/**
 * Add meta boxes
 *
 * @return void
 */
function schat_add_meta_boxes() {
	
	//
	// Chat options meta box
	// 
	$screens = array( 'post', 'page' );

	// Get all custom post types (only public post types)
	$custom_post_types = get_post_types( array( '_builtin' => false, 'public' => true ) );

	// Merge all post types
	$screens = array_merge( $screens, $custom_post_types );
	
	foreach ($screens as $screen) {
		add_meta_box(
			'schat_opts',
			__( 'Chat Options', 'schat' ),
			'schat_render_opts_meta',
			$screen,
			'side'
		);
	}

	// 
	// Visitors
	// 
	add_meta_box(
		'schat_visitor',
		__( 'Visitor Details', 'schat' ),
		'schat_render_visitor',
		'schat_visitor',
		'normal',
		'high'
	);

	// 
	// Offline messages
	// 
	add_meta_box(
		'schat_offl_msg', 
		__( 'Offline Message', 'schat' ),
		'schat_render_offline_msg',
		'schat_offline_msg',
		'normal',
		'high'
	);

	add_meta_box(
		'schat_offl_msg_details', 
		__( 'Message Details', 'schat' ),
		'schat_render_offline_msg_details',
		'schat_offline_msg',
		'side'
	);
	
	add_meta_box(
		'schat_offl_msg_usr', 
		__( 'Sender', 'schat' ),
		'schat_render_offline_msg_sender',
		'schat_offline_msg',
		'side'
	);

}

/**
 * Render visitors metabox
 *
 * @return void
 */
function schat_render_visitor( $post ) {

	// Use nonce for verification
	wp_nonce_field( plugin_basename( __FILE__ ), 'schat_nonce' ); 

	// Get user details
	$title = get_post_meta( $post->ID, 'Title', 1 );
	$email = get_post_meta( $post->ID, 'Email', 1 );
	$ip_addr = get_post_meta( $post->ID, 'IP Address', 1 );

	?>
	
	<p>
		<label><?php _e( 'Full name', 'schat' ); ?>:</label><br>
		<input type="text" name="schat_title" id="schat_visitor_title" value="<?php echo $title; ?>">
	</p>

	<p>
		<label><?php _e( 'E-mail', 'schat' ); ?>:</label><br>
		<input type="text" name="schat_email" id="" value="<?php echo $email; ?>">
	</p>


	<script>
		(function ($) { $(document).ready(function () {
			
			// Hide publish box details
			$('#misc-publishing-actions').hide();

		}); } (window.jQuery || window.Zepto));
	</script>	
	
<?php
}

/**
 * Render offline messages metabox
 *
 * @return void
 */
function schat_render_offline_msg( $post ) {

	

	?>

	<div class="schat-offline-msg-wrap">
		<div class="schat-offline-msg-content">
			<?php echo wpautop( $post->post_content ); ?>
		</div>

	</div>
<?php

	
}

/**
 * Render offline messages sender metabox
 *
 * @return void
 */
function schat_render_offline_msg_sender( $post ) { 

	// Specific user info
	$name = get_post_meta( $post->ID, 'name', 1 );
	$email = get_post_meta( $post->ID, 'email', 1 );
	$phone = get_post_meta( $post->ID, 'phone', 1 );
	

	?>

	<ul>
		<?php 
		if( !empty( $name ) )
			echo '<li><strong>' . __('Name', 'schat' ) . '</strong>: ' . $name . '</li>';

		if( !empty( $email ) )
			echo '<li><strong>' . __('Email', 'schat' ) . '</strong>: <a href="mailto:' . $email . '">' . $email . '</a></li>';

		if( !empty( $phone ) )
			echo '<li><strong>' . __('Phone', 'schat' ) . '</strong>: ' . $phone . '</li>';
		?>

		<li><strong><?php _e( 'IP Address', 'schat' ); ?>:</strong> <?php echo get_post_meta( $post->ID, 'ip_addr', 1 ); ?></li>
		<li><strong><?php _e( 'Browser', 'schat' ); ?>:</strong> <?php echo get_post_meta( $post->ID, 'browser', 1 ) . ' ' . get_post_meta( $post->ID, 'version', 1 ); ?></li>
		<li><strong><?php _e( 'OS', 'schat' ); ?>:</strong> <?php echo get_post_meta( $post->ID, 'os', 1 ); ?></li>
		
		

	</ul>
	
<?php 
	
}

/**
 * Render offline messages details metabox
 *
 * @return void
 */
function schat_render_offline_msg_details( $post ) {

	// Email sent to offline emails ?
	$status = get_post_meta( $post->ID, 'status', 1 );
	$receiver = get_post_meta( $post->ID, 'to', 1 );

	?>

	<ul>
		<li><strong><?php _e( 'Date', 'schat' ); ?>:</strong> <?php echo get_the_date() . ' ' . get_the_time(); ?></li>
		<li><strong><?php _e( 'Receiver', 'schat' ); ?>:</strong> <?php echo $receiver; ?></li>
	</ul>

	<?php

	if( $status == 'failed' )
		echo '<p style="color:red">' . __( 'Message has NOT been sent to offline emails!', 'schat' ) . '</p>';
	else
		echo '<p style="color:green">' . __( 'Message has been received to offline emails successfully.', 'schat' ) . '</p>';
}

/**
 * Render chat options metabox
 *
 * @return void
 */
function schat_render_opts_meta( $post ) {
	
	// Get fields
	$f_customize = get_post_meta( $post->ID, 'schat_opt_customize', true ); 
	$f_display = get_post_meta( $post->ID, 'schat_display', true ); 
	$f_autoinit_sec = get_post_meta( $post->ID, 'schat_autoinit_sec', true ); 

	// Use nonce for verification
	wp_nonce_field( plugin_basename( __FILE__ ), 'schat_nonce' );
	
	// Display chat box?
	echo '<strong>' . __( 'Display chat box', 'schat' ) . ':</strong><br>';
	echo '<label><input type="radio" name="schat_display" id="schat_display_default" value="" ' . checked( $f_display, '', false ) . ' /> ' . __( 'Default', 'schat' ) . '</label> ';
	echo '<label><input type="radio" name="schat_display" id="schat_display_show" value="show" ' . checked( $f_display, 'show', false ) . ' /> ' . __( 'Show', 'schat' ) . '</label> ';
	echo '<label><input type="radio" name="schat_display" id="schat_display_hide" value="hide" ' . checked( $f_display, 'hide', false ) . ' /> ' . __( 'Hide', 'schat' ) . '</label><br><br>';

	// Auto-initiate chat ?>
	
	<!-- <strong><?php _e( 'Auto-initiate chat after', SCHAT_PX ); ?></strong><br>
	<input type="text" name="schat_autoinit_sec" id="schat_autoinit_sec"  value="<?php echo ( !empty( $f_autoinit_sec ) ) ? $f_autoinit_sec : 0; ?>" size="4"> 
		<span style="color:gray"><?php _e( 'second(s)', SCHAT_PX ); ?></span><br>
		<small style="color:gray"><?php _e( 'Set 0 (zero) to use default value in chat settings', SCHAT_PX ); ?></small><br><br>
 -->
	<?php
	// Customize chat box
	/*echo '<label>';
	
	echo '<input type="checkbox" name="schat_opt_customize" id="schat_opt_customize" ' . checked( $f_show_chatbox, 'on', false ) . ' value="on" /> ' . __( 'Customize chat box', 'sc_chat' );
	 
	echo '</label>';*/

}

/**
 * Row actions for all post types
 *
 * @return array
 */
function schat_row_actions( $actions, $post ) {

	switch( $post->post_type ) {
		case 'schat_visitor':
		/*	unset( $actions['inline hide-if-no-js'] );
			unset( $actions['edit'] );
			unset( $actions['trash'] );

			// Add new actions
			// $actions['block'] = "<a class='submitdelete' title='" . esc_attr( __( 'Block this user from chatting with operators', 'schat' ) ) . "' href='" . admin_url( 'edit.php?post_type=schat_visitor&ID=' . $post->ID . '&action=block' ) . "'>" . __( 'Block', 'schat' ) . "</a>";
			$actions['trash'] = "<a class='submitdelete' title='" . esc_attr( __( 'Delete this item permanently' ) ) . "' href='" . get_delete_post_link( $post->ID, '', true ) . "'>" . __( 'Delete Permanently', 'schat' ) . "</a>";
*/
		break;

	}

	return $actions;
}

/**
 * Save post data
 *
 * @return void
 */
function schat_save_post( $post_ID ) {

	$post_type = get_post_type();

	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) 
		return;
	
	// Check nonce
	$_nonce = ( !empty( $_POST['schat_nonce'] ) ) ? $_POST['schat_nonce'] : '';

	if ( !wp_verify_nonce( $_nonce, plugin_basename( __FILE__ ) ) )
		return;

	// Check permissions
	switch( $post_type ) {
		
		case 'page':
			if( !current_user_can( 'edit_page', $post_ID ) ) 
				return;

		case 'post':
			if( !current_user_can( 'edit_post', $post_ID ) )
				return;
	}

	// Save form data
	/*switch ( $post_type ) {
		case 'post':
		case 'page':
			
			

			break;

		
	}*/

	// Update options
	add_post_meta( $post_ID, 'schat_display', $_POST['schat_display'], true ) or update_post_meta( $post_ID, 'schat_display', $_POST['schat_display'] );
	// add_post_meta( $post_ID, 'schat_autoinit_sec', $_POST['schat_autoinit_sec'], true ) or update_post_meta( $post_ID, 'schat_autoinit_sec', $_POST['schat_autoinit_sec'] );
}

/** 
 * Send a POST requst using cURL 
 * @param string $url to request 
 * @param array $post values to send 
 * @param array $options for cURL 
 * @return string 
 */ 
function schat_curl_post( $url, array $post = NULL, array $options = array() ) { 
	
	$defaults = array( 
		CURLOPT_POST => 1, 
		CURLOPT_HEADER => 0, 
		CURLOPT_URL => $url, 
		CURLOPT_FRESH_CONNECT => 1, 
		CURLOPT_RETURNTRANSFER => 1, 
		CURLOPT_FORBID_REUSE => 1, 
		CURLOPT_TIMEOUT => 7,
		CURLOPT_SSL_VERIFYPEER => false,
		CURLOPT_FAILONERROR => true,
		CURLOPT_SSL_VERIFYPEER => 2,
		CURLOPT_USERAGENT => "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.1) Gecko/20061204 Firefox/2.0.0.1",
		CURLOPT_POSTFIELDS => http_build_query( $post, '', '&' )
	); 

	$ch = curl_init(); 
	curl_setopt_array($ch, ( $options + $defaults )); 
	
	if( ! $result = curl_exec( $ch ) )  { 
		$result['error'] = curl_error( $ch );
		$result['error_no'] = curl_errno( $ch );
		trigger_error( curl_error( $ch ) ); 
	}

	curl_close($ch);

	return $result; 

} 